from src.pageobject.mainpage import MainPage
from selenium.webdriver.common.by import By

# 直播页面-讨论区操作
class LiveDiscussPage(MainPage):
    # 元素集

    # 讨论tab
    discuss_tab = (By.XPATH, "//div[@class='sectionTab']/讨论")
    # 讨论文字输入框
    discuss_box = (By.XPATH, "//div[@class='textBox']")
    # 发送按钮
    discuss_submit_btn = (By.XPATH, "//span[@class='button']/ant-btn ant-btn-primary ant-btn-sm submit")
    # 学员禁言按钮
    discuss_forbid = (By.XPATH, "//span[@class='ant-checkbox']/ant-checkbox-input")

    def __init__(self, driver):
        MainPage.__init__(self, driver)

    # 点击讨论tab
    def click_camera_btn(self):
        self.click(self.discuss_tab)

    # 点击讨论内容输入框
    def click_discuss_box(self):
        self.click(self.discuss_box)

    # 点击发送讨论文字
    def click_discuss_submit_btn(self):
        self.click(self.discuss_submit_btn)

    # 点击全员禁言
    def click_discuss_forbid(self):
        self.click(self.discuss_forbid)


