import configparser
import os
import json
import platform


config = configparser.ConfigParser()
dir = os.path.abspath('.').split('src')[0]
config.read(dir + "/config/config.ini", encoding='utf-8')


# 根据配置文件获取测试url
def test_location():
    current_platform = platform.system().lower()
    if current_platform == "windows":
        location = config.get("testServer", "win_app_location")
        return location
    elif current_platform == "darwin":
        location = config.get("testServer", "mac_app_location")
        return location


# 获取测试的环境
def get_env():
    env = config.get("testEnv", "env")
    return env


def test_header(header_name):
    return_test = config.get("header_require", header_name)
    return json.loads(return_test)


def test_day_exchange():
    return_test = config.get("day exchange", "week_name")
    return json.loads(return_test)
