import time

import allure
import pytest

from src.pageobject.livediscusspage import LiveDiscussPage
from src.framework.appDriver import get_app_driver

from src.framework.logger import Logger
from src.framework.common import create_a_live

from config import readConfig

import sys


class TestLivePage(object):
    cloud_class_location = readConfig.test_location()
    driver = get_app_driver(cloud_class_location)
    Live_Discuss_Page = LiveDiscussPage(driver=driver)

    @pytest.fixture(scope="module", autouse=True)
    def before_test(self):
        self.logger = Logger('live page').getlog()
        time.sleep(15)

        live_course_name = create_a_live(start_time=25, user="zhangy-b")
        # 这里停15s是因为setUP里创建直播间获取token登录了一次，限制两次登录需间隔15s

        self.Live_Discuss_Page.login(user='zhangy-b')
        self.Live_Discuss_Page.sleep(2)
        # print("***********"+live_course_name[0])
        self.Live_Discuss_Page.click_in_live_btn(live_course_name[0])
        # self.Live_Discuss_Page.click_in_live_btn("blGT35WO"[0])
        self.Live_Discuss_Page.sleep(5)
        self.Live_Discuss_Page.change_window(self.Live_Discuss_Page.discuss_tab)
        self.Live_Discuss_Page.click_discuss_tab()
        self.Live_Discuss_Page.sleep(2)

        # yield self.driver
        # self.driver.quit()

    @pytest.mark.run(order=1)
    @allure.title("切换页面到讨论区")
    def testDiscussField1(self):
        # 点击“讨论”按钮
        self.Live_Discuss_Page.click_discuss_tab()
        # 判断出现文字输入框
        assert self.Live_Discuss_Page.ifElementExist(self.Live_Discuss_Page.discuss_box)

    @pytest.mark.run(order=2)
    @allure.title("讨论区输入文字")
    def testDiscussField1(self):
        self.Live_Discuss_Page.click_discuss_tab()
        self.Live_Discuss_Page.sleep(2)
        self.Live_Discuss_Page.click_discuss_box()
        self.Live_Discuss_Page.input_discuss_word()
        assert self.Live_Discuss_Page.ifElementExist(self.Live_Discuss_Page.discuss_box)

    @pytest.mark.run(order=3)
    @allure.title("讨论区发送文字")
    def testDiscussField1(self):
        # 点击“讨论”按钮
        self.Live_Discuss_Page.click_discuss_tab()
        self.Live_Discuss_Page.sleep(2)
        self.Live_Discuss_Page.click_discuss_box()
        self.Live_Discuss_Page.input_discuss_word()
        self.Live_Discuss_Page.sleep(2)
        self.Live_Discuss_Page.click_discuss_submit_btn()

        assert self.Live_Discuss_Page.ifElementExist(self.Live_Discuss_Page.discuss_box)

    @pytest.mark.run(order=4)
    @allure.title("全员禁言/取消禁言")
    def testDiscussField1(self):
        # 点击“讨论”按钮
        self.Live_Discuss_Page.click_discuss_tab()
        self.Live_Discuss_Page.sleep(2)
        self.Live_Discuss_Page.click_discuss_forbid()
        self.Live_Discuss_Page.sleep(2)

        assert self.Live_Discuss_Page.ifElementExist(self.Live_Discuss_Page.discuss_forbided)

        self.Live_Discuss_Page.click_discuss_forbided()
        self.Live_Discuss_Page.sleep(2)

        assert self.Live_Discuss_Page.ifElementExist(self.Live_Discuss_Page.discuss_forbid)




if __name__ == '__main__':
    pytest.main(["-v"])