import allure
import pytest

from src.framework.logger import Logger
from src.pageobject.mainsidebarpage import MainSideBarPage
from src.framework.appDriver import get_app_driver

from config import readConfig


class TestMainPage(object):
    cloud_class_location = readConfig.test_location()
    driver = get_app_driver(cloud_class_location)
    Main_Side_Bar_Page = MainSideBarPage(driver=driver)
    sleep_time = 1

    @pytest.fixture(scope="module", autouse=True)
    def before_test(self):
        self.logger = Logger('main side bar page').getlog()
        self.Main_Side_Bar_Page.login()
        self.Main_Side_Bar_Page.sleep(self.sleep_time)
        yield self.driver
        self.driver.quit()

    @allure.title("测试设备检测")
    @allure.description("如果测试当前用例的时候存在其他客户端浏览器，可能会测试不通过")
    @pytest.mark.run(order=1)
    def testEquipment(self):
        self.Main_Side_Bar_Page.click_set_btn()
        self.Main_Side_Bar_Page.sleep(self.sleep_time)
        self.Main_Side_Bar_Page.click_test_equipment_btn()
        self.Main_Side_Bar_Page.change_window(self.Main_Side_Bar_Page.test_equipment_title)
        assert self.Main_Side_Bar_Page.ifElementExist(self.Main_Side_Bar_Page.test_equipment_title)
        self.Main_Side_Bar_Page.click_close_equipment_window()

    @allure.title("测试检查更新")
    @pytest.mark.run(order=2)
    def testCheckUpdate(self):
        self.Main_Side_Bar_Page.change_window(self.Main_Side_Bar_Page.check_update_btn)
        self.Main_Side_Bar_Page.click_check_update_btn()
        self.Main_Side_Bar_Page.sleep(self.sleep_time)
        assert self.Main_Side_Bar_Page.ifElementExist(self.Main_Side_Bar_Page.check_update_word)
        self.Main_Side_Bar_Page.sleep(self.sleep_time)
        self.Main_Side_Bar_Page.click_close_update_window()

    @allure.title("测试退出登录")
    @pytest.mark.run(order=3)
    def testLogout(self):
        self.Main_Side_Bar_Page.click_set_btn()
        self.Main_Side_Bar_Page.click_logout_btn()
        assert self.Main_Side_Bar_Page.ifElementExist(self.Main_Side_Bar_Page.login_title)


if __name__ == '__main__':
    pytest.main(["-v"])
