from src.pageobject.basepage import Page
from selenium.webdriver.common.by import By


# 登录页面
class LoginPage(Page):
    # 元素集

    # 手机号登录按钮
    phone_login = (By.ID, "rc-tabs-0-tab-2")
    # 账号输入框
    account_input = (By.ID, "xmphone")
    # 密码输入框
    password_input = (By.ID, "xmpwd")
    # 登录按钮
    login_button = (By.CLASS_NAME, "submit")


    # 验证元素
    # 店铺名称
    store_name = (By.CLASS_NAME, "inst")

    def __init__(self, driver):
        Page.__init__(self, driver)

    # 点击手机号登录，展示输入框
    def click_phone_login(self):
        self.click(self.phone_login)

    # 输入账号
    def input_account(self, account):
        self.input_text(self.account_input, account)

    # 输入密码
    def input_password(self, password):
        self.input_text(self.password_input, password)

    # 点击登录
    def click_login(self):
        self.click(self.login_button)
