from src.pageobject.loginpage import LoginPage
from selenium.webdriver.support import expected_conditions as EC
from selenium.webdriver.common.by import By


# 主页面
class MainPage(LoginPage):
    # 元素集

    # "今日"按钮
    today_btn = (By.CLASS_NAME, "today")
    # "月份"按钮
    month_btn = (By.CLASS_NAME, "month")
    # "最小化"按钮
    min_btn = (By.XPATH, "//div[@class='iconBaner']//span[1]")
    # "刷新"按钮
    refresh_btn = (By.XPATH, "//div[@class='iconBaner']//span[2]")
    # "关闭"按钮
    close_btn = (By.XPATH, "//div[@class='iconBaner']//span[3]")
    # 获取直播列表
    live_list = (By.CLASS_NAME, "list-content")
    # "进入直播间"按钮         format里面的参数还是要继续修改，先创建课程，再通过课程名称来查看进入直播间按钮
    in_live_btn = (By.XPATH, """//div[text()={{coursename}}]/..//button[@class="ant-btn ant-btn-primary"]""".format())
    # 开始直播按钮
    start_live_btn = (By.XPATH, """//span[text()="是"]""")
    # 结束直播按钮
    stop_live_btn = (By.XPATH, """//span[text()="结束直播"]""")
    # 二次确认直播按钮
    cancel_stop_live_btn = (By.XPATH, """//span[text()="取 消"]""")

    # 验证元素
    # 开启/关闭摄像头按钮
    camera_btn = (By.XPATH, "//div[@class='camera']/span")

    def __init__(self, driver):
        LoginPage.__init__(self, driver)

    # 点击'今日'
    def click_today_btn(self):
        self.click(self.today_btn)

    # 点击'月份'
    def click_month_btn(self):
        self.click(self.month_btn)

    # 点击'最小化'
    def click_min_btn(self):
        self.click(self.min_btn)

    # 点击'刷新'
    def click_refresh_btn(self):
        self.click(self.refresh_btn)

    # 点击'关闭'
    def click_close_btn(self):
        self.click(self.close_btn)

    # 点击'进入直播间'
    def click_in_live_btn(self, coursename):
        self.in_live_btn = (By.XPATH, """//div[text()="{}"]/..//button[@class="ant-btn ant-btn-primary"]""".format(coursename))
        self.click(self.in_live_btn)

    # 点击'查看回放'
    def click_review_live_btn(self, coursename):
        self.in_live_btn = (By.XPATH, """//div[text()="{}"]/..//button[@class="ant-btn"]""".format(coursename))
        while True:
            self.keys_down()
            ele = EC.presence_of_element_located(self.in_live_btn)
            if ele:
                break
        self.click(self.in_live_btn)

    def click_camera_btn(self):
        self.click(self.camera_btn)

    def start_live(self):
        self.click(self.start_live_btn)

    def stop_live(self):
        self.click(self.stop_live_btn)

    def get_live_name(self):
        self.keys_down()

    # 获取按钮文本
    def get_btn_text(self, coursename):
        self.in_live_btn = (By.XPATH, """//div[text()="{}"]/..//button[@class="ant-btn"]""".format(coursename))
        return self.get_text(self.in_live_btn)

    def page_down(self, coursename):
        while True:
            self.keys_down()
            ele = EC.presence_of_element_located((By.XPATH, """//div[text()={}]/..//button[@class="ant-btn"]""".format(coursename)))
            if ele:
                break
