import time

import allure
import pytest

from src.pageobject.livecamerapage import LiveCameraPage
from src.framework.appDriver import get_app_driver

from src.framework.logger import Logger
from src.framework.common import create_a_live
from src.framework.common import screenshot_path, compare_pictures, year_to_minute
from src.framework.common import get_allure_screenshots

from config import readConfig

import sys


class TestLivePage(object):
    cloud_class_location = readConfig.test_location()
    driver = get_app_driver(cloud_class_location)
    Live_Camera_Page = LiveCameraPage(driver=driver)

    @pytest.fixture(scope="module", autouse=True)
    def before_test(self):
        self.logger = Logger('live page').getlog()
        time.sleep(15)
        live_course_name = create_a_live(start_time=25)
        # 这里停15s是因为setUP里创建直播间获取token登录了一次，限制两次登录需间隔15s
        self.Live_Camera_Page.sleep(15)
        self.Live_Camera_Page.login()
        self.Live_Camera_Page.sleep(2)
        print(live_course_name[0])
        self.Live_Camera_Page.click_in_live_btn(live_course_name[0])
        self.Live_Camera_Page.sleep(2)
        self.Live_Camera_Page.change_window(self.Live_Camera_Page.camera_btn)
        self.Live_Camera_Page.sleep(2)
        yield self.driver
        self.driver.quit()

    @pytest.mark.run(order=1)
    @allure.title("测试摄像头功能-关闭摄像头-方法1")
    def testCloseCameraByFunction1(self):
        before_close_camera = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.Live_Camera_Page.save_screenshot(before_close_camera)
        get_allure_screenshots(before_close_camera, "关闭摄像头前截图")
        self.Live_Camera_Page.click_camera_btn()
        self.Live_Camera_Page.sleep(1)
        after_close_camera = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.Live_Camera_Page.save_screenshot(after_close_camera)
        get_allure_screenshots(after_close_camera, "关闭摄像头后截图")
        result = compare_pictures(before_close_camera, after_close_camera)
        print(result)
        assert 100 < result

    @pytest.mark.run(order=2)
    @allure.title("测试摄像头功能-开启摄像头")
    def testOpenCamera(self):
        before_open_camera = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.Live_Camera_Page.save_screenshot(before_open_camera)
        get_allure_screenshots(before_open_camera, "开启摄像头前截图")
        self.Live_Camera_Page.click_camera_btn()
        self.Live_Camera_Page.sleep(1)
        after_open_camera = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.Live_Camera_Page.save_screenshot(after_open_camera)
        get_allure_screenshots(after_open_camera, "开启摄像头后截图")
        result = compare_pictures(before_open_camera, after_open_camera)
        print(result)
        assert 100 < result

    @pytest.mark.run(order=3)
    # @pytest.mark.skip()
    @allure.title("测试摄像头功能-摄像头镜像")
    def testOpenCameraImage(self):
        self.Live_Camera_Page.excute_script_display("topBox")
        before_open_camera_image = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.Live_Camera_Page.save_screenshot(before_open_camera_image)
        get_allure_screenshots(before_open_camera_image, "开启摄像头镜像前截图")
        self.Live_Camera_Page.sleep(1)
        self.Live_Camera_Page.ifElementClickable(self.Live_Camera_Page.camera_image)
        self.Live_Camera_Page.click_camera_image()
        self.Live_Camera_Page.sleep(1)
        after_open_camera_image = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.Live_Camera_Page.save_screenshot(after_open_camera_image)
        get_allure_screenshots(after_open_camera_image, "开启摄像头镜像后截图")
        result = compare_pictures(before_open_camera_image, after_open_camera_image)
        print(result)
        assert 30 < result

    @pytest.mark.run(order=4)
    @pytest.mark.skip()
    @allure.title("测试摄像头功能-关闭摄像头-方法2")
    def testCloseCameraByFunction2(self):
        self.Live_Camera_Page.excute_script_display("topBox")
        before_open_camera_image = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.Live_Camera_Page.save_screenshot(before_open_camera_image)
        get_allure_screenshots(before_open_camera_image, "关闭摄像头前截图")
        self.Live_Camera_Page.sleep(1)
        self.Live_Camera_Page.click_close_camera_btn()
        after_open_camera_image = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.Live_Camera_Page.save_screenshot(after_open_camera_image)
        get_allure_screenshots(after_open_camera_image, "关闭摄像头后截图")
        result = compare_pictures(before_open_camera_image, after_open_camera_image)
        print(result)
        assert 30 < result


if __name__ == '__main__':
    pytest.main(["-v"])
