from src.framework.logger import Logger
from src.pageobject.whiteboardpage import WhiteBoardPage
from src.framework.common import create_a_live
from src.framework.appDriver import get_app_driver
from src.framework.common import screenshot_path, compare_pictures, year_to_minute

from config import readConfig

import unittest
import sys


class TestLivePage(unittest.TestCase):
    logger = Logger('live page').getlog()
    cloud_class_location = readConfig.test_location()
    live_course_name = create_a_live(start_time=25, start_time2=1)
    driver = get_app_driver(cloud_class_location)
    live_page = WhiteBoardPage(driver=driver)
    # 这里停15s是因为setUP里创建直播间获取token登录了一次，限制两次登录需间隔15s
    live_page.sleep(15)
    live_page.login()
    live_page.sleep(2)
    live_page.click_in_live_btn(live_course_name[0])
    live_page.sleep(5)
    live_page.change_window(live_page.camera_btn)
    live_page.sleep(5)

    def setUp(self) -> None:
        # 指定客户端的本地路径,在/config/config.ini配置
        pass

    @classmethod
    def tearDownClass(cls) -> None:
        cls.driver.quit()

    # 测试白板功能-文本输入
    def testWhiteBoard(self):
        self.live_page.click_white_board()
        self.live_page.sleep(2)
        self.live_page.click_add_white_board()
        self.live_page.click_camera_btn()
        self.live_page.sleep(1)
        self.live_page.click_open_white_board()

        self.live_page.click_wenben()
        self.live_page.sleep(3)
        # 切换iframe前后都要点击一次才能生效，神奇
        self.live_page.move_get_wenben()
        self.live_page.switch_to_iframe("webview")
        self.live_page.move_get_wenben()
        print(self.live_page.ifElementExist(self.live_page.wenben_text))
        self.live_page.sleep(1)
        before_send_wenben = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.live_page.save_screenshot(before_send_wenben)
        # 切换iframe后必须时textarea才能输入文本
        self.live_page.input_wenben("11111")
        self.live_page.sleep(1)
        after_send_wenben = screenshot_path(sys._getframe().f_code.co_name) + "/" + year_to_minute() + '.png'
        self.live_page.save_screenshot(after_send_wenben)
        wenben_result = compare_pictures(before_send_wenben, after_send_wenben)
        print(wenben_result)
        self.assertLessEqual(10, wenben_result)


if __name__ == '__main__':
    unittest.main(verbosity=1)
