from src.pageobject.loginpage import LoginPage
from src.framework.logger import Logger
from src.framework.appDriver import get_app_driver
from config import readConfig

import unittest


class TestLoginPage(unittest.TestCase):
    logger = Logger('login page').getlog()
    account = readConfig.test_account()
    password = readConfig.test_password()
    cloud_class_location = readConfig.test_location()

    def setUp(self) -> None:
        print(11111)
        # 指定客户端的本地路径,在/config/config.ini配置
        self.driver = get_app_driver(self.cloud_class_location)

    def tearDown(self) -> None:
        self.driver.quit()

    # 测试登录
    def testLogin(self):
        driver = self.driver
        login_page = LoginPage(driver=driver)
        login_page.click_phone_login()
        login_page.input_account(account=self.account)
        login_page.input_password(password=self.password)
        login_page.click_login()
        login_page.sleep(1)
        # 校验是否存在店铺名称的元素
        self.assertTrue(login_page.ifElementExist(login_page.store_name))


if __name__ == '__main__':
    unittest.main(verbosity=1)
