import time

import allure
import pytest

from src.pageobject.livediscusspage import LiveDiscussPage
from src.framework.appDriver import get_app_driver

from src.framework.logger import Logger
from src.framework.common import create_a_live

from config import readConfig

import sys


class TestLiveRoomPage(object):
    cloud_class_location = readConfig.test_location()
    driver = get_app_driver(cloud_class_location)
    Live_Discuss_Page = LiveDiscussPage(driver=driver)

    @pytest.fixture(scope="module", autouse=True)
    def before_test(self):
        self.logger = Logger('live page').getlog()
        time.sleep(15)
        live_course_name = create_a_live(start_time=25)
        # 这里停15s是因为setUP里创建直播间获取token登录了一次，限制两次登录需间隔15s

        self.Live_Discuss_Page.login()
        self.Live_Discuss_Page.sleep(2)
        # print(live_course_name[0])
        self.Live_Discuss_Page.click_in_live_btn(live_course_name[0])
        self.Live_Discuss_Page.sleep(2)
        # self.Live_Discuss_Page.change_window(self.Live_Discuss_Page.camera_btn)

        self.Live_Discuss_Page.sleep(2)

        yield self.driver
        self.driver.quit()



if __name__ == '__main__':
    pytest.main(["-v"])