from src.pageobject.mainpage import MainPage
from selenium.webdriver.common.by import By


# 直播页面-摄像头操作
class LiveCameraPage(MainPage):
    # 元素集

    # 开启/关闭摄像头按钮
    camera_btn = (By.XPATH, "//div[@class='camera']/span")
    # 摄像头ele
    camera_ele = (By.XPATH, "//div[@class='react-draggable']")
    # 画面内的摄像头关闭按钮
    close_camera_btn = (By.XPATH, "//span[@class='iconBox']/span")
    # 画面内的摄像头镜像按钮
    camera_image = (By.XPATH, "//span[@class='iconBox trans']/span")

    def __init__(self, driver):
        MainPage.__init__(self, driver)

    # 点击摄像头
    def click_camera_btn(self):
        self.click(self.camera_btn)

    # 鼠标选择在摄像头画面
    def mouse_on_camera(self):
        self.mouse_stop_until_ele_show(self.find_element(self.camera_ele), self.camera_image)

    # 点击关闭摄像头
    def click_close_camera_btn(self):
        self.click(self.close_camera_btn)

    # 点击开启摄像头镜像
    def click_camera_image(self):
        self.click(self.camera_image)

    # 摄像头ele
    camera_ele1 = (By.XPATH, "//div[@class='react-draggable']/div[1]")
    # 摄像头ele
    camera_ele2 = (By.XPATH, "//div[@class='react-draggable']/div[1]/div[1]")
    # 摄像头ele
    camera_ele3 = (By.XPATH, "//div[@class='react-draggable']/div[1]/div[1]/div[1]")
    # 摄像头ele
    camera_ele4 = (By.XPATH, "//div[@class='react-draggable']/div[1]/div[1]/div[1]/canvas")
    # 摄像头ele
    camera_ele5 = (By.XPATH, "//div[@class='drag tl']")

    list = [camera_ele, camera_ele1, camera_ele2, camera_ele3, camera_ele4, camera_ele5]

    def test_mouse_on_camera(self):
        for self.i in self.list:
            self.sleep(1)
            self.ifElementExist(self.i)
            self.mouse_stop_until_ele_show(self.find_element(self.i), self.camera_image)
            print(self.i)

