import allure
import pytest

from src.pageobject.loginpage import LoginPage
from src.framework.logger import Logger
from src.framework.appDriver import get_app_driver
from config import readConfig


class TestLoginPage(object):
    @pytest.fixture(scope="function")
    def before_test_case(self):
        self.logger = Logger('login page').getlog()
        self.account = readConfig.test_account()
        self.password = readConfig.test_password()
        cloud_class_location = readConfig.test_location()
        self.env = readConfig.get_env()
        # 指定客户端的本地路径,在/config/config.ini配置
        self.driver = get_app_driver(cloud_class_location)
        yield self.driver
        self.driver.quit()

    @allure.title("测试登录")
    @pytest.mark.usefixtures("before_test_case")
    def testLogin(self):
        login_page = LoginPage(driver=self.driver)
        login_page.sleep(1)
        # 执行脚本，隐藏的手机号码输入框弹出
        # login_page.phone_input_execute_script()
        login_page.click_phone_login()
        login_page.input_account(account=self.account)
        login_page.input_password(password=self.password)
        # login_page.get_env_window()
        # login_page.click_what('span', 'text()', self.env)
        # login_page.click_close_env_window()
        login_page.click_login()
        login_page.sleep(2)
        login_page.click_text("取 消")
        login_page.sleep(3)
        # 校验是否存在店铺名称的元素
        assert login_page.ifElementExist(login_page.store_name)


if __name__ == '__main__':
    pytest.main(["-v"])
