from src.pageobject.basepage import Page
from selenium.webdriver.common.by import By


# 主页面-侧边bar
class MainSideBarPage(Page):
    # 元素集
    # 设置按钮
    set_btn = (By.XPATH, "//div[@class='setting']//span[1]")
    # 检测设备按钮
    test_equipment_btn = (By.XPATH, "//span[text()='设备检测']")
    # 检查更新按钮
    check_update_btn = (By.XPATH, "//span[text()='检查更新']")
    # 退出登录按钮
    logout_btn = (By.XPATH, "//span[text()='退出登录']")
    # 帮助按钮
    help_btn = (By.XPATH, "//div[@class='setting']//span[2]")

    # 切换窗口元素
    # 设备检测标题
    test_equipment_title = (By.XPATH, "//div[text()='设备检测']")
    # 关闭检测设备窗口
    close_equipment_window = (By.XPATH, "//span[text()='完 成']")
    # 测试扬声器按钮窗口
    test_speaker_btn = (By.XPATH, "//button[@class='ant-btn speakerBtn']")
    # 检查更新为最新版本时
    check_update_word = (By.XPATH, "//span[text()='好']")
    # 检查更新为非最新版本时

    # 校验元素
    # 退出登录后的元素
    login_title = (By.XPATH, "//div[text()='小麦企学院(讲师版)']")

    def __init__(self, driver):
        Page.__init__(self, driver)

    # 点击设置按钮
    def click_set_btn(self):
        self.click(self.set_btn)

    # 点击检测设备按钮
    def click_test_equipment_btn(self):
        self.click(self.test_equipment_btn)

    # 点击关闭检测设备窗口
    def click_close_equipment_window(self):
        self.click(self.close_equipment_window)

    # 点击检查更新按钮
    def click_check_update_btn(self):
        self.click(self.check_update_btn)

    # 点击关闭检查更新窗口
    def click_close_update_window(self):
        self.click(self.check_update_word)

    # 点击退出登录按钮
    def click_logout_btn(self):
        self.click(self.logout_btn)

    # 点击帮助按钮
    def click_help_btn(self):
        self.click(self.help_btn)

