import time

import allure
import pytest

from src.framework.logger import Logger
from src.framework.common import week_day, month_day, month_not_today
from src.pageobject.mainbarpage import MainBarPage
from src.framework.appDriver import get_app_driver

from config import readConfig


class TestMainPage(object):
    @pytest.fixture(scope="module", autouse=True)
    def before_test(self):
        print("before_test")
        self.logger = Logger('main bar page').getlog()
        self.cloud_class_location = readConfig.test_location()
        return self.cloud_class_location

    @pytest.fixture(scope="function", autouse=True)
    def before_test_case(self, before_test):
        print("before_test_case")
        # 指定客户端的本地路径,在/config/config.ini配置
        self.cloud_class_location = before_test
        self.sleep_time = 2
        self.driver = get_app_driver(self.cloud_class_location)
        self.main_bar_page = MainBarPage(driver=self.driver)
        self.main_bar_page.login()
        yield self.driver
        self.driver.quit()

    @allure.title("校验今日选择日期是否正确")
    @pytest.mark.run(order=1)
    def test_IfTrueSelectedDay(self):
        self.main_bar_page.sleep(self.sleep_time)
        assert self.main_bar_page.month_day_text() == str(month_day())
        assert self.main_bar_page.week_day_text() == readConfig.test_day_exchange()[str(week_day())]

    @allure.title("点击已选择相邻第一个的未选择日期")
    def test_SelectOtherDay(self):
        if week_day() != 6:
            first_day = month_not_today(-week_day()-1).strftime("%d")
        else:
            first_day = month_not_today(1).strftime("%d")
        self.main_bar_page.click_other_day()
        assert self.main_bar_page.month_day_text() == first_day

    @allure.title("切换到其他日期再切回今日")
    def test_SelectToday(self):
        if week_day() != 6:
            first_day = month_not_today(-week_day()-1).strftime("%d")
        else:
            first_day = month_not_today(1).strftime("%d")
        self.main_bar_page.click_other_day()
        assert self.main_bar_page.month_day_text() == first_day
        self.main_bar_page.click_today()
        today = month_not_today(0).strftime("%d")
        assert self.main_bar_page.month_day_text() == today

    @allure.title("点击上周")
    def test_SelectLastWeek(self):
        first_day = month_not_today(-7).strftime("%d")
        self.main_bar_page.click_last_week()
        assert self.main_bar_page.month_day_text() == first_day

    @allure.title("点击下周")
    def test_SelectNextWeek(self):
        first_day = month_not_today(7).strftime("%d")
        self.main_bar_page.click_next_week()
        assert self.main_bar_page.month_day_text() == first_day

    @allure.title("点击上个月")
    def test_SelectLastMonth(self):
        this_month = self.main_bar_page.get_month_text()
        self.main_bar_page.click_month_btn()
        self.main_bar_page.sleep(self.sleep_time)
        self.main_bar_page.click_last_month()
        last_month = self.main_bar_page.get_other_month_text()
        assert this_month != last_month

    @allure.title("点击下个月")
    def test_SelectNextMonth(self):
        this_month = self.main_bar_page.get_month_text()
        self.main_bar_page.click_month_btn()
        self.main_bar_page.sleep(self.sleep_time)
        self.main_bar_page.click_next_month()
        next_month = self.main_bar_page.get_other_month_text()
        assert this_month != next_month


if __name__ == '__main__':
    pytest.main(["-v"])
