import React from 'react';
import Service from '@/common/js/service';
import { AppId } from '@/common/js/config'
import  queryString from  'query-string';
import './index.less';

class Authorize extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      code:'',
      ticket:'',
      hasBindWechat:false,
      headImgUrl:''
    }
  }
  componentDidMount() {
    const code = window.getParameterByName('code');
    const ticket = window.getParameterByName('ticket');
    this.setState({
      code,
      ticket
    })
    if(!code){
      this.setState({
        ticketState:"SCAN_SUCCESS"
      },()=>this.changeCodeState())
    }else{
      this.getWechatUserInfo();
    }
  }
  changeCodeState = ()=>{
    let {ticket,ticketState} = this.state;
    const params = {
      ticket,
      ticketState
    }
    Service.hades('/anon/hades/changeTicketState',params).then(
    )
  }
  wechatAuthorize = () => {
    let path = window.location.href;
    let htmlUrl = 'https://open.weixin.qq.com/connect/oauth2/authorize?appid=' + AppId +
    '&redirect_uri=' + encodeURIComponent(path) +
    '&response_type=code&scope=snsapi_userinfo&state=state#wechat_redirect';
    window.location.href = htmlUrl;
  }

  getWechatUserInfo = ()=>{
    const code = window.getParameterByName('code');
    const ticket = window.getParameterByName('ticket');
    const storeId = window.getParameterByName('storeId');
    const params = {
      appTermEnum: "XIAOMAI_CLOUD_CLASS_PC_WEB_CUSTOMER",
      code,
      storeId,
      ticket
    }
    Service.hades('/anon/hades/bindWeChat',params).then((res)=>{
      if(res.success){
        localStorage.setItem('wechat-common_user_avatar_url',res.result.headImgUrl || 'https://image.xiaomaiketang.com/xm/HsCjyKTbWw.png')
        localStorage.setItem('wechat-common_user_open_id',res.result.openId)
        localStorage.setItem('wechat-common_user_nick_name',res.result.nickName)
        // if(!res.result.whetherOld){
          //1.审核开关打开，并且新用户第一次登陆，未提交过审核（审核状态为空）跳转提交审核页面
          if(res.result.auditSwitch === 'OPEN'&& !res.result.applyStatus ){
            window.RCHistory.replace(`/wechat-audit?storeId=${storeId}`);
            return
          }
          //2.审核开关打开，已提交过审核，审核状态为WAIT（等待审核）或者REJECTED（已被拒绝）时；跳转审核等待页；
          if(res.result.auditSwitch === 'OPEN' && (res.result.applyStatus === 'WAIT' || res.result.applyStatus==='REJECTED' )){
            window.RCHistory.replace(`/wechat-audit-result?storeId=${storeId}`);
            return
          }
        // }
        this.setState({
          hasBindWechat:true,
          headImgUrl:res.result.headImgUrl,
          ticketState:"AUTH_SUCCESS"
        },()=>{this.changeCodeState()})
       
      }
    })
  }

  render() {
    const { hasBindWechat , headImgUrl} = this.state
    return (
      <div className="authorize-page">
        
        <div>
          { !hasBindWechat &&
            <div> 
              <div>
                <img src="https://image.xiaomaiketang.com/xm/HsCjyKTbWw.png" className="avatar-img" alt=''></img>
              </div>
              <button className="login-btn" onClick={this.wechatAuthorize}>微信登录</button>
            </div>
          }

          { hasBindWechat && 

            <div>
               <div>
                <img src={headImgUrl} className="avatar-img" alt=''></img>
              </div>
              <div className="login-success-text">微信登录成功</div>
              <div  className="login-success-instro">已完成微信登录操作，去网页端继续学习吧</div>
            </div>
          }
        </div>
      </div>

    )
  }
}
export default Authorize;
