import React, { useState } from "react";
import { Form, Button, Input } from "antd";
import Service from "@/common/js/service";
import "./WechatAudit.less";
const WechatAudit = function () {
  const storeId = window.getParameterByName("storeId");
  const [realName, setRealName] = useState("");
  const avatarUrl= localStorage.getItem('wechat-common_user_avatar_url')
  const openId= localStorage.getItem('wechat-common_user_open_id')
  const nickName = localStorage.getItem('wechat-common_user_nick_name')


  function saveUserInfo() {

    const params = {
      openId,
      nickName,
      avatarUrl,
      storeId,
      realName
    };
    Service.hades("anon/customerHades/applyJoin", params).then((res) => {
      if(res.success === true ){
        window.location.href = `${window.location.origin}${window.location.pathname}#/wechat-audit-result?storeId=${storeId}`
      }
    });
  }
  return (
    <div className="wechat-audit">
      <div className="box">
        <div className="title">登录申请</div>
        <div className="tip">
          请输入您的真实姓名并提交申请，通过申请后即可登录学院
        </div>
        <Form>
          <div className="name-item">
            <Input
              placeholder="请输入姓名，最多6个字符"
              style={{ width: 300, height: 32 }}
              value={realName}
              maxLength={6}
              onChange={(e) => {
                setRealName(e.target.value);
              }}
            />
          </div>

          <div className={realName ? "save-btn" : "save-btn disable"}>
            <Button
              type="primary"
              onClick={() => {
                saveUserInfo();
              }}
            >
              申请加入
            </Button>
          </div>
        </Form>
      </div>
    </div>
  );
};
export default WechatAudit;
