import React from 'react';
import Service from '@/common/js/service';
import { AppId } from '@/common/js/config'
import  queryString from  'query-string';
import './index.less';

class Authorize extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      code:'',
      ticket:'',
      hasBindWechat:false,
      headImgUrl:''
    }
  }
  componentDidMount() {
    const code = window.getParameterByName('code');
    const ticket = window.getParameterByName('ticket');
    this.setState({
      code,
      ticket
    })
    if(!code){
      this.setState({
        ticketState:"SCAN_SUCCESS"
      },()=>this.changeCodeState())
    }else{
      this.getWechatUserInfo();
    }
  }
  changeCodeState = ()=>{
    let {ticket,ticketState} = this.state;
    const params = {
      ticket,
      ticketState
    }
    Service.hades('/anon/hades/changeTicketState',params).then(
    )
  }
  wechatAuthorize = () => {
    let path = window.location.href;
    let htmlUrl = 'https://open.weixin.qq.com/connect/oauth2/authorize?appid=' + AppId +
    '&redirect_uri=' + encodeURIComponent(path) +
    '&response_type=code&scope=snsapi_userinfo&state=state#wechat_redirect';
    window.location.href = htmlUrl;
  }

  getWechatUserInfo = ()=>{
    const code = window.getParameterByName('code');
    const ticket = window.getParameterByName('ticket');
    const params = {
      appTermEnum: "XIAOMAI_CLOUD_CLASS_PC_WEB_CUSTOMER",
      code,
      storeId:"1192022572770412395",
      ticket
    }
    Service.hades('/anon/hades/bindWeChat',params).then((res)=>{
      if(res.success){
        this.setState({
          hasBindWechat:true,
          headImgUrl:res.result.headImgUrl,
          ticketState:"AUTH_SUCCESS"
        },()=>{this.changeCodeState()})
      }
    })
  }

  render() {
    const { hasBindWechat , headImgUrl} = this.state
    return (
      <div className="authorize-page">
        
        <div>
          { !hasBindWechat &&
            <div> 
              <div>
                <img src="https://image.xiaomaiketang.com/xm/HsCjyKTbWw.png" className="avatar-img"></img>
              </div>
              <button className="login-btn" onClick={this.wechatAuthorize}>微信登录</button>
            </div>
          }

          { hasBindWechat && 

            <div>
               <div>
                <img src={headImgUrl} className="avatar-img"></img>
              </div>
              <div className="login-success-text">微信登录成功</div>
              <div  className="login-success-instro">已完成微信登录操作，去网页端继续学习吧</div>
            </div>
          }
        </div>
      </div>

    )
  }
}
export default Authorize;
