/*
 * @Author: 吴文洁
 * @Date: 2020-04-27 20:35:34
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2021-01-05 17:37:20
 * @Description:
 */

import React from 'react';
import ReactDOM from 'react-dom';
import { HashRouter } from 'react-router-dom';
import { ConfigProvider } from 'antd';
import { createHashHistory } from 'history';
import zh_CN from 'antd/es/locale/zh_CN';
import _ from 'underscore';

import Storage from '@/common/js/storage';
import { PREFIX } from '@/domains/basic-domain/constants';
import { VerifyInfo } from '@/domains/basic-domain/interface';

import 'antd/dist/antd.less';
import '@/common/less/index.less';
import '@/common/js/function';

import App from './App';

import '@/common/less/index.less';

const history = createHashHistory();

window.RCHistory = _.extend({}, history, {
  push: (obj: any) => {
    history.push(obj)
  },
  pushState:  (obj: any) => {
    history.push(obj)
  },
  pushStateWithStatus: (obj: any) => {
    history.push(obj)
  },
  goBack: history.goBack,
	location: history.location,
	replace: (obj: any) => {
		history.replace(obj)
	}
});

export async function mount() {
  ReactDOM.render((
    <HashRouter {...history} >
      <ConfigProvider locale={zh_CN}>
        <App />
      </ConfigProvider>
    </HashRouter>
  ), document.getElementById('root'));
}
mount();




