import React from 'react';
import Service from '@/common/js/service';
import './index.less';

class WorkWxAuthorize extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      scanState:'',
      messageText:''
    }
  }
  componentDidMount() {
    const code = window.getParameterByName('code');
    if(!code){
      this.workWechatAuthorize();
    }else{
      this.workWechatLogin();
    }
  }
  workWechatLogin= ()=>{
    const code = window.getParameterByName('code');
    const ticket = window.getParameterByName('ticket');
    const storeId = window.getParameterByName('storeId');
    Service.hades("anon/hades/wXWorkUserTicketLogin", {
        appTermEnum: 'XIAOMAI_CLOUD_CLASS_PC_WEB_CUSTOMER',
        code,
        ticket,
        storeId
    }, (res) => {
        if (res.code == 200) {
            this.setState({
              scanState:'success'
            })
        } else {
          let message = res.message.split(',').join('<br />')
          this.setState({
            scanState:'error',
            messageText:message
          })
        }
    })
  }
  workWechatAuthorize = () => {
    const params = {}
    Service.hades('anon/hades/getCorpTrainSuiteId',params).then((res)=>{
      let path = window.location.href;
      const htmlUrl = `https://open.weixin.qq.com/connect/oauth2/authorize?appid=${res.result}&redirect_uri=${encodeURIComponent(path)}&response_type=code&scope=snsapi_privateinfo&state=STATE#wechat_redirect`
      window.location.href = htmlUrl;
    })
    
  }

  render() { 
    const { scanState,messageText} = this.state;
    return (
      <div className="work-authorize-page">
         <div className="box">
            { scanState === 'success' && 
             <div className="success">
                <img src="https://image.xiaomaiketang.com/xm/iRkcMHPHba.png"  alt=""/>
                <p>
                  扫码成功
                </p>
              </div>
           } 
          { scanState === 'error' &&
            <div className="error">
              <img src="https://image.xiaomaiketang.com/xm/6kSAYFMm2r.png
              "  alt="" />
              <p className='message'>
                { messageText }
              </p>
            </div>
          }
        </div>
      </div>

    )
  }
}
export default WorkWxAuthorize;
