import React, { useEffect, useState } from "react";
import { debounce } from "underscore";
import Service from "@/common/js/service";
import "./WechatAuditResult.less";
const WechatAuditResult = function () {
  const [status, setStatus] = useState("WAIT");
  const storeId =window.getParameterByName("storeId");
  const [headImgUrl,setHeadImgUrl] = useState(localStorage.getItem('wechat-common_user_avatar_url'))
  const openId = localStorage.getItem('wechat-common_user_open_id')
  useEffect(() => {
    getStatus();
  }, []);
  function getStatus() {
    const params={
      openId,
      storeId
    }
    Service.hades("anon/customerHades/getCustomerAudit", params).then((res) => {
      const {result:{applyStatus,auditSwitch}}= res
      if(auditSwitch === 'CLOSE'){
        setStatus('PASSED')
      }else{
        setStatus(applyStatus)
      }
     

    });
  }

  return (
    <div className="wechat-audit-result">
      <Choose>
        <When condition={status === "WAIT"}>
          <div className="box">
            <img
              className="img"
              src="https://image.xiaomaiketang.com/xm/6isseQhcTh.png"
              alt=""
            />
            <div className="desc">申请审核中</div>
            <div className="tip">
              您已成功提交申请，待系统审核通过后，才能登录学院
            </div>
            <div
              className="btn reload"
              onClick={debounce(() => getStatus("fail"), 3000, true)}
            >
              刷新
            </div>
          </div>
        </When>
        <When condition={status === "PASSED"}>
              <div className='box'>
                <img src={headImgUrl} className="avatar-img" alt=''></img>
              <div className="login-success-text">微信登录成功</div>
              <div  className="login-success-instro">已完成微信登录操作，去网页端继续学习吧</div>
              </div>
        </When>
        <Otherwise>
          <div className="box">
            <img
              className="img"
              src="https://image.xiaomaiketang.com/xm/cQzJDFZDsp.png"
              alt=""
            />
            <div className="desc">审核失败</div>
            <div className="tip">
              请输入您的真实姓名并提交申请，通过申请后就可以登录学院
            </div>
            <div
              className="btn reload"
              onClick={() => {
                window.location.href =
                  window.location.origin +
                  window.location.pathname +
                  `#/wechat-audit?storeId=${storeId}`;
              }}
            >
              重新申请
            </div>
          </div>
        </Otherwise>
      </Choose>
    </div>
  );
};
export default WechatAuditResult;
