import React from 'react';
import {Table, Modal,Input} from 'antd';
import { PageControl } from "@/components";
import PlanService from '@/domains/plan-domain/planService'
import User from '@/common/js/user'
import './UserLearnDetailModal.less';
import _ from "underscore";
const { Search } = Input;
const defaultCover = 'https://image.xiaomaiketang.com/xm/YNfi45JwFA.png';
const CourseType = {
  LIVE: {
    text: "直播课"
  },
  VOICE : {
    text:"视频课"
  },
  RECORD : {
    text:'录播课'
  }
};
const courseStateShow = {
  UN_START: {
    title: "待开播",
  },
  STARTING: {
    title: "直播中",
  },
  FINISH: {
    title: "回放",
  },
  EXPIRED: {
    title: "未成功开课",
  },
};
class UserLearnDetailModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      planDataSource:[],
      taskDataSource:[],
      taskSize:10,
      taskQuery: {
        current: 1,
      },
      taskTotalCount:0,
      courseDataSource:[],
      storeCustomerName:'',
      storeCustomerPhone:''
    };
  }
  componentDidMount() {
    this.getPlanCustomerDetail();
  }
  getPlanCustomerDetail = ()=>{
    PlanService.getPlanCustomerDetail({
       planId:getParameterByName("id"),
       storeCustomerId:this.props.storeCustomerId,
       storeId:User.getStoreId()
    }).then((res) => {
      const {
        storeCustomerName,
        storeCustomerPhone,
        planName,
        learnFinishPercentage,
        taskCustomerVOList,
        courseMediaVOS,
      }=res.result;
        let coverUrl;
        courseMediaVOS.map((item) => {
          if(item.contentType === "COVER"){
            coverUrl = item.mediaUrl;
          }
          return item;
        })
        const planDataSource = [{
          planName,
          learnFinishPercentage,
          coverUrl:coverUrl || defaultCover
        }]
        this.setState({
          storeCustomerName,
          storeCustomerPhone,
          planDataSource,
          taskDataSource:taskCustomerVOList
        })
    })
  }
  parsePlanColumns = () => {
    const columns = [
      {
        title: '培训计划名称',
        key: 'planInfo',
        dataIndex: 'planInfo',
        render: (val, record) => {
          return (
            <div className="plan-instro">
              <div className="img-con">
                <img src={record.coverUrl}/>
              </div>
              <div className="plan-name">{record.planName}</div>
            </div>
          )
        }
      },
      {
        title: '学习进度',
        key: 'learnFinishPercentage',
        dataIndex: 'learnFinishPercentage',
        width:167,
        render: (val, record) => {
          return (
            <div className="plan-learn-percentage">
               {val}%
            </div>
          )
        }
      }
    ];
    return columns;
  }

  parseTaskColumns = () => {
    const columns = [
      {
        title: '培训任务',
        key: 'taskName',
        dataIndex: 'taskName',
        render: (val, record,index) => {
          return (
            <div className="taskName">
              {index + 1}.{record.taskName}
            </div>
          )
        }
      },
      {
        title: '学习进度',
        key: 'learnFinishPercentage',
        dataIndex: 'learnFinishPercentage',
        width:167,
        render: (val, record) => {
          return (
            <div className="task-learn-percentage">
              { val === 100 ?<span>已完成</span>:<span>{val}%</span>}
            </div>
          )
        }
      }
    ];
    return columns;
  }
  parseCoursecolumns = (parentIndex) => {
    const columns = [
      {
        title: '课程',
        key: 'courseName',
        dataIndex: 'courseName',
        render: (val, record,index) => {
          return (
            <div className="course-info">
              <div className="course-type">{CourseType[record.courseType].text}</div>
              <div className="name-and-state">
                <span className="course-name">{parentIndex + 1}.{index + 1} {record.courseName}</span>
                { record.courseType==="LIVE" &&
                <span className="course-state">{courseStateShow[record.courseState].title}</span>
                }
              </div>
            </div>
          )
        }
      },
      {
        title: '学习进度',
        key: 'learnFinishPercentage',
        dataIndex: 'learnFinishPercentage',
        width:152,
        render: (val, record) => {
          return (
            <div className="course-learn-percentage">
               { record.learnState === "FINISH"  ?<span>已完成</span>:<span>{val}%</span>}
            </div>
          )
        }
      }
    ];
    return columns;
  }
  render() {
    const {storeCustomerName,storeCustomerPhone,planDataSource,taskDataSource,taskQuery,taskTotalCount} = this.state;
    const { visible } = this.props;
    return (
        <Modal
          title="用户学习详情"
          onCancel={this.props.onClose}
          onOk={this.props.onClose}
          maskClosable={false}
          visible={visible}
          className="user-Learn-modal"
          closable={true}
          width={800}
          closeIcon={<span className="icon iconfont modal-close-icon">&#xe6ef;</span>} 
        >
          <div className="customer-info">
            <span className="customer-name">
              <span>用户：</span>
              <span>{storeCustomerName}</span>
            </span>
            <span className="customer-phone">
              <span>手机号：</span>
              <span>{storeCustomerPhone}</span>
            </span>
          </div>
          <div>
           <Table
              dataSource={planDataSource}
              columns={this.parsePlanColumns()}
              pagination={false}
              bordered
              className="plan-table"
            />
          </div>
          <div>
            <Table
              rowKey={(record) => record.taskId}
              className="task-table"
              dataSource={taskDataSource}
              columns={this.parseTaskColumns()}
              pagination={false}
              expandedRowRender={(record,index) => {
                if(!record.courseVOList){
                  return
                }
                if (record.courseVOList.length !== 0 ){
                  return  <div>
                            <Table
                              pagination={false}
                              dataSource={record.courseVOList}
                              columns={this.parseCoursecolumns(index)}
                              className="child-table"
                            />
                      </div>
                }
              }}
              rowClassName={(record,index)=>{if(index%2===0){return 'odd-row'}else{ return 'even-row'}}}
            />
          </div>
        </Modal>
    )
  }
}

export default UserLearnDetailModal;