/*
 * @Author: yuananting
 * @Date: 2021-08-16 17:35:15
 * @LastEditors: yuananting
 * @LastEditTime: 2021-08-16 22:06:40
 * @Description: 描述一下咯
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { useEffect, useState } from 'react';
import { withRouter } from 'react-router-dom';
import RichText from '@/components/RichText';
import ExpiredCourseList from '../../train-task/components/ExpiredCourseList';
import ENUM from '../../enum';
import './course.less';

function CourseTable(props: any) {
  const taskId = props.match.params.taskId.replace(/\?.+/, '');
  const IndexText = ['一', '二', '三', '四', '五', '六', '七', '八', '九', '十'];
  const [list, setList] = useState<any[]>([]);
  useEffect(() => {
    setList(props.info.trainingStageList || []);
  }, [props.info.trainingStageList]);

  return (
    <div className='courseTabContent'>
      <div className='tips'>
        {`培训目的：`}

        <RichText url={props.info?.intro?.mediaUrl} />
      </div>

      <div className='coursecontent'>
        {list?.map((item: any, index: number) => {
          return (
            <div className='task'>
              <div
                className='title'
                onClick={() => {
                  const _list = [...list];
                  _list[index].open = !_list[index].open;
                  setList(_list);
                }}>
                {item.open ? <span className='icon iconfont open'>&#xe614;</span> : <span className='icon iconfont'>&#xe614;</span>}
                {`${IndexText[index]}、 `}
                {item.stageName}
              </div>
              {item.open && (
                <div className='taskItemList'>
                  {item.contentVOList.map((_item: any, _index: number) => {
                    return (
                      <div className={_index == item.contentVOList.length - 1 ? 'item noBorder' : 'item'}>
                        <div className='name'>
                          <img className='type-option-icon' src={ENUM.LearningContentIcon[_item.courseType || _item.contentType]} />
                          <span style={{ marginRight: 4 }}> {`${index + 1}.${_index + 1}`}</span>

                          {_item.contentName}
                          {_item.courseType == 'LIVE' && <span className='desc'>{ENUM.courseStateShow[_item.courseState].title}</span>}
                          {_item.courseType == 'VOICE' && <span className='desc'>{`(共${_item.courseChapterNum}节)`}</span>}
                        </div>
                      </div>
                    );
                  })}
                </div>
              )}
            </div>
          );
        })}
      </div>
      <div className='expired'>
        <ExpiredCourseList taskId={taskId} />
      </div>
    </div>
  );
}

export default withRouter(CourseTable);
