/*
 * @Description:
 * @Author: zangsuyun
 * @Date: 2021-03-12 10:43:10
 * @LastEditors: wufan
 * @LastEditTime: 2021-05-30 20:36:42
 * @Copyright: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React from "react";
import { message } from 'antd'
import KnowledgeBaseFilter from "./components/KnowledgeBaseFilter";
import KnowledgeBaseOpt from "./components/KnowledgeBaseOpt";
import KnowledgeBaseList from "./components/KnowledgeBaseList";
import Classification from "./components/Classification";

import KnowledgeAPI from '@/data-source/knowledge/request-api';
import User from '@/common/js/user';

export default class KnowledgeBase extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      query: {
        size: 10,
        current: 1,
        storeId: User.getStoreId(),
        categoryId: 0,
      },
      dataSource: [], // 知识库列表
      totalCount: 0, // 知识库数据总条数
      categoryId: '0',
      updateCategoryFlag: false,
      selectedRowKeys: [],
    };
  }

  componentWillMount() {
    // 获取知识库列表
    this.handleFetchScheduleList();
    // this.getCategoryTree()
  }
  getSelectedCategoryId = (categoryId) => {
    this.setState({
      categoryId,
    });
    this.handleFetchScheduleList({ categoryId, current: 1 });
  };

  // 更新分类树
  updateCategoryTree = () => {
    this.setState({
      updateCategoryFlag: !this.state.updateCategoryFlag,
    });
  };
  // 获取知识库列表
  handleFetchScheduleList = (_query = {}, flag = true) => {
    const query = {
      ...this.state.query,
      ..._query,
    };

    // 更新请求参数
    this.setState({ query });

    flag &&
      KnowledgeAPI.queryPageKnowledgeForManager(query).then((res) => {
        // KnowledgeAPI.videoSchedulePage(query).then((res) => {
        const { result = {} } = res || {};
        const { records = [], total = 0 } = result;
        this.setState({
          dataSource: records,
          totalCount: Number(total),
        });
      });
  };

  onSelectChange = (selectedRowKeys) => {
    if (selectedRowKeys.length > 50) {
      message.warning('最多只能选择50个题目');
    }
    const list = _.filter(selectedRowKeys, (item, index) => index < 50);
    this.setState({ selectedRowKeys: list });
  };

  render() {
    const {
      dataSource,
      totalCount,
      query,
      categoryId,
      updateCategoryFlag,
      selectedRowKeys,
    } = this.state;
    return (
      <div className='page'>
        <div className='content-header'>知识库</div>

        <div className='box' style={{ display: 'flex' }}>
          {/* 搜索模块 */}
          <div className='left' style={{ width: 245 }}>
            <Classification updateCategoryFlag={updateCategoryFlag} categoryId={categoryId} getSelectedCategoryId={this.getSelectedCategoryId} />
          </div>
          <div className='liner' style={{ backgroundColor: 'rgb(238, 238, 238)', width: 0.5, margin: '1px 16px 1px 2px' }}></div>
          <div className='right' style={{ width: 'calc(100% - 265px)' }}>
            <KnowledgeBaseFilter onChange={this.handleFetchScheduleList} />

            {/* 操作模块 */}
            <KnowledgeBaseOpt
              onChange={this.handleFetchScheduleList}
              updateCategoryTree={this.updateCategoryTree}
              categoryId={categoryId}
              selectedRowKeys={selectedRowKeys}
              onChangeKeys={(keys) => this.setState({ selectedRowKeys: keys })}
            />

            {/* 知识库列表模块 */}
            <KnowledgeBaseList
              query={query}
              selectedRowKeys={selectedRowKeys}
              onSelectChange={this.onSelectChange}
              categoryId={categoryId}
              dataSource={dataSource}
              totalCount={totalCount}
              onChange={this.handleFetchScheduleList}
              updateCategoryTree={this.updateCategoryTree}
            />
          </div>
        </div>
      </div>
    );
  }
}
