import React, { useEffect, useState } from 'react';
import { Empty, ConfigProvider, Table } from 'antd';

function XMTable(props) {
  const [empty, setEmpty] = useState(props.renderEmpty || {});
  const [data, setData] = useState({});

  useEffect(() => {
    setEmpty(props.renderEmpty)
    delete props.renderEmpty;
    setData(props);
  }, [props]);

  // 自定义表格空状态
  function customizeRenderEmpty() {
    return (
      <Empty
        image={empty.image || Empty.PRESENTED_IMAGE_SIMPLE}
        imageStyle={{
          height: 150,
        }}
        description={empty.description}
      ></Empty>
    );
  };

  return (
    <ConfigProvider renderEmpty={customizeRenderEmpty}>
      <Table
        {...data}
      />
    </ConfigProvider>
  )
}

export default XMTable;