import React from 'react';
import { withRouter } from "react-router-dom";
import { Form, Input, Button, Checkbox ,Select,Modal,message} from 'antd';
import {industryList,childIndustryList} from '@/domains/store-domain/constants'
import SelectPrepareFileModal from '@/modules/prepare-lesson/modal/SelectPrepareFileModal';
import Upload from '@/core/upload';
import StoreService from "@/domains/store-domain/storeService";
import User from "@/common/js/user";
import Bus from '@/core/tbus';
import ImgClipModal from '@/components/ImgClipModal'
import "./StoreInfo.less";
let cutFlag = false;
class StoreInfo extends React.Component {
  formRef = React.createRef();
  constructor(props) {
    super(props);
    this.state = {
      storeName:null,
      storeFullName:null,
      subjectType:null,
      corpIndustry:null,
      corpSubIndustry:null,
      logo:'',
      showSelectFileModal:false,
      cutImageBlob: null,
      imageFile: null, // 需要被截取的图片
    }
  }
  componentWillMount(){
    this.getStoreDetail()
  }
  getStoreDetail = ()=>{
    const params= {
      storeId:User.getStoreId()
    }
    StoreService.getStoreDetail(params).then((res) => {
      const { result = { } } = res;
      const {
        storeName,
        storeFullName,
        subjectType,
        corpIndustry,
        corpSubIndustry,
        logo
      } = result;
      this.formRef.current.setFieldsValue({
        storeName:storeName
      });
      this.formRef.current.setFieldsValue({
        storeFullName:storeFullName
      });
      this.formRef.current.setFieldsValue({
        subjectType:subjectType
      });
      this.formRef.current.setFieldsValue({
        corpIndustry:corpIndustry
      });
      this.formRef.current.setFieldsValue({
        corpSubIndustry:corpSubIndustry
      });
      this.setState({
        storeName,
        storeFullName,
        subjectType,
        corpIndustry,
        corpSubIndustry,
        logo
      })
    });
  }
  onChangeFiledValue=(filed,value)=>{
    this.setState({
      [filed]:value
    })
  }
  handleSelectCover = (file)=> {
    this.setState({
      visible: true,
      imageFile:file
    });
  }
  
  //获取resourceId
  getSignature = (blob, fileName) => {
    Upload.uploadBlobToOSS(blob, 'cover' + (new Date()).valueOf(),null,'signInfo').then((signInfo) => {
      this.setState({
        coverClicpPath:signInfo.fileUrl,
        coverId:signInfo.resourceId,
        visible: false
      },()=>this.updateCover())
    
    });
  };
  updateCover = () =>{
    const {coverClicpPath,coverId} = this.state
    this.setState({
      showSelectFileModal: false
    })
    this.setState({
      logo:coverClicpPath
    })
  }
  updateInfo=()=>{
    const {storeName,storeFullName,logo,subjectType,corpIndustry,corpSubIndustry} = this.state;
    if(!storeName){
      message.warning('请输入学院简称');
     return;
    }
    if(!storeFullName){
      message.warning('请输入学院名称');
      return;
    }
    if(!subjectType){
      message.warning('请选择学院类型');
      return;
    }
    if(!corpIndustry){
      message.warning('请选择学院所属行业');
      return;
    }
    const params= {
      storeName,
      storeFullName,
      logo,
      subjectType,
      corpIndustry,
      corpSubIndustry,
      storeId:User.getStoreId()
    }
    StoreService.updateStoreMessage(params).then((res) => {
      User.setStoreName(storeName);
      Bus.trigger('storeNameChange',storeName);
      message.success('保存成功');
    });
  }
  render() {
    const {storeName,storeFullName,subjectType,corpIndustry,corpSubIndustry,showSelectFileModal,visible,hasImgReady,logo,cutImageBlob,imageFile} = this.state;
    return (
      <div className="page store-info-page">
        <div className="content-header">学院基本信息</div>
        <div className="box">
          <div className="store-info-header">学院基本信息</div>
          <div className="store-info-page-form">
           
            <Form ref={this.formRef}>
              <Form.Item
                label="学院简称"
                name="storeName"
                rules={[{ required: true}]}
              >
                <Input  value={storeName} style={{ width: '300px' }} placeholder="请输入学院简称" onChange={(e)=>this.onChangeFiledValue("storeName",e.target.value)} maxLength={20}/>
              </Form.Item>
              <Form.Item
                label="学院名称"
                name="storeFullName"
                rules={[{ required: true}]}
              >
                <Input value={storeFullName} style={{ width: '300px' }} placeholder="请输入学院名称" onChange={(e)=>this.onChangeFiledValue("storeFullName",e.target.value)} maxLength={30}/>
              </Form.Item>
          
              <Form.Item
                label="学院logo"
              >
                <div className="logo-con">
                  <div className="logo-img-con">
                    { logo ?  <img src={logo}  className="logo-img"/> : <div className="logo-box"><span className="text">Logo</span></div>}
                  </div>
                  <div className="operate-con">
                    <div><span onClick={() => {this.setState({ showSelectFileModal:true  })}} className="upload-btn">
                      {logo ? <span>重新上传</span> : <span>上传</span> }
                    </span></div>
                    <div className="tip">建议尺寸702*180px。最大2M，支持jpg、jpeg和png。</div>
                  </div>  
                </div>
              </Form.Item>
              <Form.Item
                label="学院类型"
                name="subjectType"
                rules={[{ required: true }]}
              >
                <Select
                  placeholder="Select a option and change input text above"
                  allowClear
                  style={{ width: '300px' }}
                  placeholder="请选择学院类型"
                  value={subjectType}
                  onChange={(value)=>this.onChangeFiledValue("subjectType",value)}
                >
                  <Option value="COMPANY">企业</Option>
                  <Option value="INSTITUTION">政府以及事业单位</Option>
                  <Option value="ELSE">其他组织</Option>
                  <Option value="TEAM ">团队号</Option>
                </Select>
              </Form.Item>
              <Form.Item
                label="学院所属行业"
                rules={[{ required: true }]}
                name="corpIndustry"
              >
                <Select
                 placeholder="请选择学院所属行业"
                  style={{ width: '300px' }}
                  allowClear
                  value={corpIndustry}
                  onChange={(value)=>this.onChangeFiledValue("corpIndustry",value)}
                >
                  {industryList.map((item,index)=>{
                    return <Option value={item}>{item}</Option>
                  })
                  }
                  
                </Select>
              </Form.Item>
              <Form.Item
                label="学院所属子行业"
                name="corpSubIndustry"
              >
                <Select
                  placeholder="请选择学院所属子行业"
                  allowClear
                  style={{ width: '300px' }}
                  value={corpSubIndustry}
                  onChange={(value)=>this.onChangeFiledValue("corpSubIndustry",value)}
                >
                  {childIndustryList[corpIndustry] && 
                      childIndustryList[corpIndustry].map((item,index)=>{
                        return <Option value={item}>{item}</Option>
                      }) 
                  }
                </Select>
              </Form.Item>
            </Form>
          </div>
          {showSelectFileModal && 
            <SelectPrepareFileModal
              key="basic"
              operateType="select"
              multiple={false}
              accept="image/jpeg,image/png,image/jpg"
              selectTypeList={['JPG', 'JPEG', 'PNG']}
              tooltip='支持文件类型：jpg、jpeg、png'
              isOpen={showSelectFileModal}
              onClose={() => {
                this.setState({
                  showSelectFileModal:false
                })
              }}
              onSelect={this.handleSelectCover}
            />
          }
          { visible &&
           <ImgClipModal visible={visible} imgUrl={imageFile.ossUrl}  aspectRatio='125/32' cropBoxHeight='128' onConfirm={this.getSignature} onClose={()=>{this.setState({ visible: false });}}/>
          }
          <div><Button type="primary" onClick={this.updateInfo} htmlType="submit" className="submit-btn">更新信息</Button></div>
        </div>

      </div>
    )
  }
}

export default withRouter(StoreInfo);