import React from 'react';
import { Modal } from 'antd';
import './PreviewOfflineModal.less';
import moment from 'moment';

const defaultCoverUrl = 'https://image.xiaomaiketang.com/xm/YNfi45JwFA.png';

class PreviewOfflineModal extends React.Component {

  constructor(props) {
    super(props);
  }

  render() {
    const { data } = this.props;
    const {
      coverUrl,
      courseName,
      categoryName,
      introduce,
      startTime,
      endTime,
      offlinePlace,
    } = data;
    return (
      <Modal
        title="预览"
        visible={true}
        width={680}
        onCancel={this.props.close}
        footer={null}
        maskClosable={false}
        closeIcon={<span className="icon iconfont modal-close-icon">&#xe6ef;</span>}
        className="preview-live-graphics-modal"
      >
        <div className="container__wrap">
          <div className="container">
            <div className="container__header">
              <img src={coverUrl || defaultCoverUrl} className="course-cover" />
            </div>
            <div className="container__body">
              <div className="title__name">{courseName}</div>
              <div className="title__categery">
                <img className="item-icon" src="https://image.xiaomaiketang.com/xm/cDMwz3jzaX.png" />
                课程分类：{categoryName}
              </div>
              <div className="title__categery">
                <img className="item-icon" src="https://image.xiaomaiketang.com/xm/BfTBK3dGda.png" />
                上课时间：{startTime ? moment(startTime).format('HH:mm') : ''}~{endTime ? moment(endTime).format('HH:mm') : ''}
              </div>
              <div className="title__categery">
                <img className="item-icon" src="https://image.xiaomaiketang.com/xm/KhFNBTtAKR.png" />
                上课地点：{offlinePlace}
              </div>
            </div> 
            
            <div className="container__introduction">
              <div className="title">线下课简介</div>
              <div className="container__introduction__list editor-box">
                <div
                  className="intro-item text"
                  dangerouslySetInnerHTML={{
                    __html: introduce
                  }}
                />
              </div>
            </div>
          </div>
        </div>
      </Modal>
    )
  }
}

export default PreviewOfflineModal;
