/*
 * @Author: wufan
 * @Date: 2021-06-15 13:48:35
 * @LastEditors: wufan
 * @LastEditTime: 2021-06-24 11:10:45
 * @Description: Description
 */
import React from 'react';
import Lottie from 'react-lottie';

import student from '@/common/lottie/student.json';
import activity from '@/common/lottie/activity.json';
import teacher from '@/common/lottie/teacher.json';
import college from '@/common/lottie/college.json';
import search from '@/common/lottie/search.json';

import './LottieIcon.less';

interface LottieIconInterface {
  size: number,
  type: string,
  title: string,
  isStopped: boolean,
  isPaused: boolean,
}

const ANIMATION_DATA_MAP: {
  [key: string]: any,
} = {
  student,
  activity,
  teacher,
  college,
  search
}

function LottieIcon(props: LottieIconInterface) {
  const {
    title,
    size = 90,
    type = 'student',
    isPaused = true,
    isStopped = true,
    
  } = props;

  const options = {
    loop: true,
    autoplay: true,
    animationData: ANIMATION_DATA_MAP[type],
    rendererSettings: {
      preserveAspectRatio: 'xMidYMid slice'
    }
  }

  return (
    <div className="lottie-icon">
      <Lottie
        options={options}
        width={size}
        height={size}
        isPaused={isPaused}
        isStopped={isStopped}
      />

      <div className="lottie-icon__title">{title}</div>
    </div>
  )
}

export default LottieIcon;