import React from 'react';
import { Modal, Button, message } from 'antd';
import html2canvas from 'html2canvas';
import User from "../../../common/js/user";
import QRCode from '../../../libs/qrcode/qrcode';
import { LIVE_SHARE } from '../../../domains/course-domain/constants';
import Service from '../../../common/js/service';
import { copyText } from '../../../domains/basic-domain/utils';

import './ExamShareModal.less';

class ExamShareModal extends React.Component {

    constructor(props) {
        super(props);
        this.state = {
            shareUrl: '',
            storeName: User.getStoreName()
        }
    }


    componentDidMount() {
        // 获取短链接
        this.handleConvertShortUrl();
    }

    handleConvertShortUrl = () => {
        const longUrl = `${LIVE_SHARE}test_detail/${this.props.data.examId}?id=${User.getStoreId()}`
        console.log(longUrl)
        // 发请求
        Service.Sales('public/businessShow/convertShortUrls', {
            urls: [longUrl]
        }).then((res) => {
            const { result = [] } = res;
            this.setState({
                shareUrl: result[0].shortUrl
            }, () => {
                const qrcodeWrapDom = document.querySelector('#qrcodeWrap');
                const qrcodeNode = new QRCode({
                    text: this.state.shareUrl,
                    size: 98,
                })
                qrcodeWrapDom.appendChild(qrcodeNode);
            });
        })
    }

    // 下载海报
    handleDownloadPoster = () => {
        const { data } = this.props;
        const dom = document.querySelector('#poster');
        html2canvas(dom, {
            useCORS: true,
        }).then(canvas => {
            const downloadDOM = document.createElement('a');
            const { courseName } = this.props.data;
            const dataUrl = canvas.toDataURL('image/png');
            downloadDOM.href = dataUrl;
            downloadDOM.download = `${data.examName}.png`;
            downloadDOM.click();
        });
    }

    // 复制分享链接
    handleCopy = () => {
        const textContent = document.getElementById('shareUrl').innerText;

        copyText(textContent);
        message.success('复制成功!');
    }

    render() {
        const { data } = this.props;
        const { shareUrl, storeName } = this.state;

        return (

            <Modal
                title="分享考试"
                width={680}
                visible={true}
                footer={null}
                maskClosable={false}
                className="ExamShareModal"
                onCancel={this.props.close}
                closeIcon={<span className="icon iconfont modal-close-icon">&#xe6ef;</span>}
            >
                <div className="left" id="poster">

                    <div
                        className="inst-name oneLineText"
                    >
                        {storeName}

                    </div>
                    <div style={{ color: '#333' }}>邀请你参与考试：</div>
                    <div className="examName">{data.examName}</div>
                    <img
                        src={'https://image.xiaomaiketang.com/xm/HQXwFsyf3e.png'}
                        className="course-cover"
                        alt="course-cover"
                    />

                    <div className="qrcode-wrap">
                        <div className="qrcode-wrap__left">
                            <div className="text">长按识别二维码进入考试</div>
                            <img
                                className="finger"
                                alt="finger"
                                src="https://image.xiaomaiketang.com/xm/thpkWDwJsC.png"
                            />
                        </div>
                        <div className="qrcode-wrap__right" id="qrcodeWrap">
                        </div>
                    </div>

                   
                </div>
                <div className="right">


                    <div className="share-poster right__item">
                        <div className="title">① 海报分享</div>
                        <div className="sub-title">用户可通过微信扫描海报二维码，查看考试</div>
                        <div className="content" onClick={this.handleDownloadPoster}>下载海报</div>
                    </div>

                    {/* <div className="share-url right__item" style={{ marginTop: 40 }}>
                        <div className="title">② 链接分享</div>
                        <div className="sub-title">用户可通过微信或浏览器打开以下链接，查看考试（建议使用谷歌浏览器）</div>
                        <div className="content">
                            <div className="share-url" id="shareUrl">{shareUrl}</div>
                            <Button
                                type="primary"
                                onClick={this.handleCopy}
                            >复制</Button>
                        </div>
                    </div> */}
                </div>
            </Modal>
        )
    }
}

export default ExamShareModal;
