/*
 * @Author: yuananting
 * @Date: 2021-08-05 11:26:25
 * @LastEditors: yuananting
 * @LastEditTime: 2021-08-05 16:20:07
 * @Description: 个人学习详情-全部tab页
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React from 'react';
import { Collapse, Progress } from 'antd';
import './WholeData.less';
import ENUM from '../../enum';
const { Panel } = Collapse;

function WholeData() {
  const SortConvert = ['一', '二', '三', '四', '五', '六', '七', '八', '九', '十'];

  const stageList = [
    {
      stageName: '新手阶段',
      finishedCount: 1,
      contentSum: 4,
      contentList: [
        {
          contentType: 'LIVE',
          contentName: '入门培训任务',
          courseState: 'UN_START',
          percent: 75,
        },
        {
          contentType: 'LIVE',
          contentName: '普通培训任务',
          courseState: 'FINISH',
          percent: 0,
        },
        {
          contentType: 'VOICE',
          contentName: '困难培训任务',
          courseChapterNum: 4,
          percent: 100,
        },
        {
          contentType: 'PICTURE',
          contentName: '困难培训任务',
          percent: 23,
        },
      ],
    },
    {
      stageName: '老手阶段',
      finishedCount: 3,
      contentSum: 5,
      contentList: [
        {
          contentType: 'LIVE',
          contentName: '入门培训任务',
          courseState: 'UN_START',
          percent: 15,
        },
        {
          contentType: 'EXAM',
          contentName: '入门考试',
          percent: 70,
        },
        {
          contentType: 'EXAM',
          contentName: '入门二段考试',
          percent: 100,
        },
      ],
    },
  ];

  const courseStateShow = {
    UN_START: {
      title: '待开播',
    },
    STARTING: {
      title: '直播中',
    },
    FINISH: {
      title: '回放',
    },
    EXPIRED: {
      title: '未成功开课',
    },
  };

  // 渲染阶段信息
  function renderStageInfo(item, index) {
    return (
      <div className='stage-info__item'>
        <span className='stage-name'>
          {SortConvert[index]}、{item.stageName}
        </span>
        <span className='extra-info'>
          （{item.finishedCount}/{item.contentSum}）
        </span>
      </div>
    );
  }

  // 渲染学习内容信息

  function renderContentInfo(contentItem, contentIndex, index) {
    const { contentName, contentType, courseChapterNum, courseState, percent } = contentItem;
    return (
      <div className='content-info__item'>
        <div className='basic-info'>
          <img src={ENUM.LearningContentIcon[contentType]} />
          <span className='content-name'>
            {contentIndex + 1}.{index + 1} {contentName}
          </span>
          {contentType === 'LIVE' && <span className='extra-info'>{courseStateShow[courseState].title}</span>}
          {contentType === 'VOICE' && <span className='extra-info'>（共{courseChapterNum || 1}小节）</span>}
        </div>
        <div className='percent-info'>
          {percent === 100 ? (
            <span className='icon iconfont'>&#xe621;</span>
          ) : (
            <Progress
              width={20}
              strokeWidth={12}
              type='circle'
              trailColor='#EAEAEA'
              strokeColor={{
                '0%': '#38B7F3',
                '100%': '#1A80E2',
              }}
              percent={percent}
            />
          )}
          <span className='text'>{percent === 100 ? '已完成' : `${percent}%`}</span>
        </div>
      </div>
    );
  }

  return (
    <div className='whole-data-container'>
      <Collapse ghost>
        {stageList.map((item, index) => {
          return (
            <Panel header={renderStageInfo(item, index)} key={index}>
              {item.contentList.map((contentItem, contentIndex) => {
                return renderContentInfo(contentItem, contentIndex, index);
              })}
            </Panel>
          );
        })}
      </Collapse>
    </div>
  );
}

export default WholeData;
