import React from 'react';
import { withRouter } from "react-router-dom";
import {Table, Modal,Input,message} from 'antd';
import { PageControl } from "@/components";
import PlanService from '@/domains/plan-domain/planService'
import User from '@/common/js/user';
import Bus from '@/core/bus';
import './EmployeeShareData.less';

const { Search } = Input;
const UserRole = {
  Store_Manager: {
    text: "店铺管理员"
  },
  Cloud_Manager: {
    text:"管理员"
  },
  Cloud_Operator: {
    text:'运营师'
  },
  Cloud_Lecture: {
    text:"讲师"
  },
};

class EmployeeShareData extends React.Component {
  constructor(props) {
    super(props);
    const id = getParameterByName("id");
    this.state = {
      id,
      dataSource:[],
      size:10,
      query: {
        current: 1,
      },
      totalCount:0,
    }
  }
  componentDidMount(){
    this.handleFetchDataList();
  }
  handleFetchDataList = ()=>{
    const { query ,size,id}  = this.state;
    const params ={
      ...query,
      size,
      planId:id,
      storeId:User.getStoreId(),
    }
    PlanService.getPlanUserRecordPage(params).then((res) => {
      const { result = {} } = res ;
      const { records = [], total = 0 } = result;
      this.setState({
          dataSource: records,
          totalCount: Number(total)
      });
    });
  }

  onShowSizeChange = (current, size) => {
    if (current == size) {
      return
    }
    this.setState({
      size
    },()=>{this.handleFetchDataList()})
  }
  handleChangeTable = (pagination, filters, sorter)=> {
    const { columnKey, order } = sorter;
    const { query } = this.state;
    let  _columnKey;
    let _order;
    if (columnKey === 'learnNum' && order === 'ascend') { _columnKey="LEARN_NUM"; _order = 'SORT_ASC'; }
    if (columnKey === 'learnNum' && order === 'descend') { _columnKey="LEARN_NUM"; _order = 'SORT_DESC'; }

    if (columnKey === 'learnFinishNum' && order === 'ascend') { _columnKey="FINISH_NUM"; _order = 'SORT_ASC'; }
    if (columnKey === 'learnFinishNum' && order === 'descend') { _columnKey="FINISH_NUM"; _order = 'SORT_DESC'; }

    if (columnKey === 'learnNoFinishNum' && order === 'ascend') { _columnKey="NOT_NUM"; _order = 'SORT_ASC'; }
    if (columnKey === 'learnNoFinishNum' && order === 'descend') { _columnKey="NOT_NUM"; _order = 'SORT_DESC'; }

    const _query = {
      ...query,
      sortMap:{}
    };
    _query.sortMap[_columnKey]=_order;
    this.setState({
      query:_query
    },()=>this.handleFetchDataList())
  }
  handleChangNickname = (value)=>{
      const isPhone = (value || '').match(/^\d+$/);
      const { query } =  this.state;
      if(isPhone){
          query.userPhone = value;
          query.userName = null;
      }else{
          query.userName = value;
          query.userPhone = null;
      }
      query.current = 1;
      this.setState({
        query
      })
  }
  watchDataView = (record)=>{
    Bus.trigger('watchDataView',record);
  } 
  // 请求表头
  parselumns = () => {
    const columns = [
      {
        title: '员工',
        key: 'storeUserName',
        dataIndex: 'storeUserName',
        render: (val, record) => {
          return (
            <div>
              {val}
            </div>
          )
        }
      },
      {
        title: '角色',
        key: 'roleEnum',
        dataIndex: 'roleEnum',
        render: (val, record) => {
          return (
            <div>
              {UserRole[record.roleEnum].text}
            </div>
          )
        }
      },
      {
        title: '手机号',
        key: 'storeUserPhone',
        dataIndex: 'storeUserPhone',
        render: (val, record) => {
          return (
            <div>
              {val}
            </div>
          )
        }
      },
      {
        title: '最近分享成功时间',
        key: 'recentlyForwardTime',
        dataIndex: 'recentlyForwardTime',
        render: (val, record) => {
          return (
            <div>
              {formatDate('YYYY-MM-DD H:i', val)}
            </div>
          )
        }
      },
      {
        title: '学习人数',
        key: 'learnNum',
        dataIndex: 'learnNum',
        width:110,
        sorter:true,
        render: (val, record) => {
          return (
            <div className="learn-num">
              {val}
            </div>
          )
        }
      },
      // {
      //   title: '已学完',
      //   key: 'learnFinishNum',
      //   dataIndex: 'learnFinishNum',
      //   width:110,
      //   sorter:true,
      //   render: (val, record) => {
      //     return (
      //       <div className="learn-finish-num">
      //         {val}
      //       </div>
      //     )
      //   }
      // },
      // {
      //   title: '未学完',
      //   key: 'learnNoFinishNum',
      //   dataIndex: 'learnNoFinishNum',
      //   width:110,
      //   sorter:true,
      //   render: (val, record) => {
      //     return (
      //       <div className="learn-no-finish-num">
      //         {val}
      //       </div>
      //     )
      //   }
      // },
      {
        title: '操作',
        key: 'operate',
        dataIndex: 'operate',
        render: (val, record) => {
          return (
            <span className="operate-item" onClick={()=>this.watchDataView(record)}>数据详情</span>
          )
        }
      }

    ];
    return columns;
  }
  render() {
    const { dataSource,query,size,totalCount} = this.state;
    return (
      <div className="employee-share-data">
        <div className="search-container">
            <Search placeholder="搜索员工姓名或手机号"  onChange={(e) => { this.handleChangNickname(e.target.value)}}  onSearch={ () => { this.handleFetchDataList()}}  style={{ width: 200 }}  enterButton={<span className="icon iconfont">&#xe832;</span>}/>
        </div>
        <div>
              <Table
                  rowKey={record => record.id}
                  dataSource={dataSource}
                  columns={this.parselumns()}
                  pagination={false}
                  onChange={this.handleChangeTable}
                  showSorterTooltip={false}
                  bordered
              />
              {dataSource.length >0 &&
                <div className="box-footer">
                    <PageControl
                        current={query.current - 1}
                        pageSize={size}
                        total={totalCount}
                        toPage={(page) => {
                            const _query = {...query, current: page + 1};
                            this.setState({
                              query:_query
                            },()=>{ this.handleFetchDataList()})
                        }}
                        onShowSizeChange={this.onShowSizeChange}
                    />
                </div>
                }
        </div>
      </div>
    )
  }
}

export default withRouter(EmployeeShareData);