import React from 'react';
import { Modal, Button } from 'antd';
import Cropper from 'react-cropper';
import 'cropperjs/dist/cropper.css';
import './ImgClipModal.less';
import { isNull } from 'underscore';
class ImgClipModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      hasImgReady: false, // 图片是否上传成功
      cropperInstace:null,
    }
  }
  render() {
    const {
      imgUrl,
      title = "设置图片",
      modalWidth=1080,
      visible,
      clipContentWidth='500px',
      clipContentHeight='430px',
      aspectRatio=16/9,
      cropBoxWidth=500,
      cropBoxHeight=282,
      previewBoxWidth='500px',
      previewBoxHeight='282px',
      onConfirm,
      onClose,
    } = this.props;
    const { hasImgReady,cropperInstace} = this.state;
    return (
        <Modal
        className="img-clip-modal"
        title={title}
        width={modalWidth}
        visible={visible}
        maskClosable={false}
        closeIcon={<span className="icon iconfont modal-close-icon">&#xe6ef;</span>}
        onCancel={() => {
          onClose();
        }}
        zIndex={10001}
        footer={[
          <Button
            key="back"
            onClick={() => {
              onClose();
            }}
          >
            重新上传
          </Button>,
          <Button
            key="submit"
            type="primary"
            disabled={!hasImgReady}
            onClick={() => {
              const cutImg = this.state.cropperInstace.getCroppedCanvas().toDataURL();
              const cutImageBlob = window.convertBase64ToBlob(cutImg);
              onConfirm(cutImageBlob);
            }}
          >
            确定
          </Button>,
        ]}
      >
        <div className="clip-box">
          <div
            style={{
              width:clipContentWidth,
              height:clipContentHeight,
              marginBottom: 0,
            }}
          >
            
          <Cropper
          style={{ height:clipContentHeight, width:clipContentWidth}}
          className="cropper__box"
          zoomTo={2}
          aspectRatio={aspectRatio}
          preview=".preview-url-box"
          src={imgUrl}
          viewMode={1}
          guides={true}
          background={false}
          responsive={true}
          autoCropArea={1}
          checkOrientation={false} 
          cropBoxResizable={false}
          center={true}
          // minCropBoxWidth={cropBoxWidth}
          // minCropBoxHeight={cropBoxHeight}
          cropBoxMovable={false}
          dragMode='move'
          onInitialized={(instance) => {
            this.setState({
              cropperInstace:instance
            })
          }}
          ready={()=>{
            this.setState({
              hasImgReady:true
            })
            this.state.cropperInstace.setCropBoxData({width:Number(cropBoxWidth),height:Number(cropBoxHeight),top:(215 - cropBoxHeight/2)});
            console.log("height++++",this.state.cropperInstace.getImageData().height);
            console.log("width++++",this.state.cropperInstace.getImageData().width);
            const ratio = (this.state.cropperInstace.getImageData().width/2)/500;
            console.log("ratio++++",ratio);
            this.state.cropperInstace.setCanvasData({width:500});
            const that = this;
            // const containerData = this.state.cropperInstace.getContainerData();

            // // Zoom to 50% from the center of the container.
            // this.state.cropperInstace.zoomTo(.5, {
            //   x: containerData.width / 2,
            //   y: containerData.height / 2,
            // });

            document.querySelector('.cropper__box').addEventListener('dblclick', function (e) {
              that.state.cropperInstace.rotate(90)
            });
          }}
        />
            
           

          </div>
          <div id="clipBtn" style={{ display: "none" }} ref="hiddenBtn"></div>
          <div className="preview-img">
            <div className="title">效果预览</div>
            <div id="preview-url-box" style={{width:previewBoxWidth,height:previewBoxHeight}} className="preview-url-box">
             
            </div>
            <div className="tip-box">
              <div className="tip">温馨提示</div>
              <div className="tip">①预览效果图时可能存在延迟，单击左侧图片刷新即可</div>
              <div className="tip">②设置图片时双击可旋转图片，滚动可放大或缩小图片</div>
            </div>
          </div>
        </div>
      </Modal>
    )
  }
}

export default ImgClipModal;