import React from 'react';
import Service from "@/common/js/service";
import BaseService from "@/domains/basic-domain/baseService";
import User from "@/common/js/user";
import moment from 'moment';
import './CollegeManagePage.less';

const roleMap = {
  CloudManager: "管理员",
  CloudLecturer: "讲师",
  StoreManager: "学院管理员",
};

export default class CollegeManagePage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      avatar: 'https://image.xiaomaiketang.com/xm/rJeQaZxtc7.png',
      name: '',
      list: [],
    };
  }

  componentDidMount() {
    const enterpriseId = User.getEnterpriseId();
    this.getStoreList(enterpriseId);
    this.getEnterpriseUser(enterpriseId);
  }
  
  getEnterpriseUser(enterpriseId) {
    const params = {
      enterpriseId,
      userId: User.getUserId(),
    }
    BaseService.getEnterpriseUser(params).then((res) => {
      const { name, avatar } = res.result;
      this.setState({ name, avatar })
    });
  }

  getStoreList(enterpriseId) {
    const params = {
      enterpriseId,
      userId: User.getUserId(),
    };
    Service.Hades('public/customerHades/getStoreListUser', params).then((res) => {
      this.setState({ list: res.result })
    });
  }

  render() {
    const {
      name,
      avatar,
      list,
    } = this.state;
    return (
      <div className="college-manage-page">
        <div className="college-header">
          <div className="box">
            <img className="box-image" src="https://image.xiaomaiketang.com/xm/HNHCAF6Fc2.png" />
            <div className="user">
              <img className="image" src={avatar} />
              <span className="name">{name}</span>
              <span
                className="logout"
                onClick={() => {
                  if (!User.getEnterpriseId()) {
                    User.setEnterpriseId(list[0].id);
                  }
                  window.RCHistory.push('/home');
                }}
              >退出</span>
            </div>
          </div>
        </div>
        <div className="college-box">
          <div className="user">
            <img className="image" src={avatar} />
            <span className="name">{name}</span>
          </div>
          <div className="title-box">
            <span className="title">企学院 ({list.length})</span>
            <span className="text">最多可创建10个企学院，您还能创建{10 - list.length}个</span>
          </div>
          <div className="college-list">
            {list.map((item) => (
              <div
                key={item.id}
                className="college-item"
                onClick={() => {
                  User.setStoreId(item.id);
                  window.RCHistory.push('/home')
                }}
              >
                <div className="header">
                  <img className="image" src={item.logo || "https://image.xiaomaiketang.com/xm/HNHCAF6Fc2.png"} />
                  <span className="tag">{roleMap[item.userRole]}</span>
                </div>
                <div className="title">{item.storeName}</div>
                <div className="time">{moment(item.createTime).format('YYYY-MM-DD HH:mm')}</div>
              </div>
            ))}
            <div
              className="college-create"
              onClick={() => {
                window.RCHistory.push('/college-manage/create')
              }}
            >
              <span className="create-word">+ 创建企学院</span>
            </div>
          </div>
        </div>
      </div>
    )
  }
}