import React, { Component } from "react";
import { Modal, Divider } from "antd";
import User from "@/common/js/user";
import QuestionBankService from "@/domains/question-bank-domain/QuestionBankService";
import "./QuestionPreviewModal.less";
import ScanFileModal from "@/modules/resource-disk/modal/ScanFileModal";
import _ from "underscore";
import XMAudio from "../components/XMAudio";
import { NUM_TO_WORD_MAP } from "@/common/constants/punchClock/punchClock";
const questionTypeList = {
  SINGLE_CHOICE: "单选题",
  MULTI_CHOICE: "多选题",
  JUDGE: "判断题",
  GAP_FILLING: "填空题",
  INDEFINITE_CHOICE: "不定项选择题",
};

class QuestionPreviewModal extends Component {
  formRef = React.createRef();
  constructor(props) {
    super(props);
    this.state = {
      questionInfo: {},
    };
  }

  componentDidMount() {
    this.queryQuestionDetails();
  }

  // 题目预览
  queryQuestionDetails = () => {
    let query = {
      id: this.props.id,
      source: 0,
      userId: User.getStoreUserId(),
      tenantId: User.getStoreId(),
    };
    QuestionBankService.queryQuestionDetails(query).then((res) => {
      const { result = [] } = res;
      this.setState({ questionInfo: result });
    });
  };

  handleScanFile = (scanFileType, scanFileAddress) => {
    this.setState({
      showScanFile: true,
      scanFileAddress,
      scanFileType,
    });
  };

  transferStemDocument = (txt) => {
    const template = `<p class='content'>${txt}</p>`;
    let doc = new DOMParser().parseFromString(template, "text/html");
    let p = doc.querySelector(".content");
    return p;
  };

  render() {
    const {
      showScanFile,
      scanFileAddress,
      scanFileType,
      questionInfo,
    } = this.state;
    const {
      questionTypeEnum,
      questionStemList,
      gapFillingAnswerList,
      optionList,
      questionAnswerDescList,
    } = questionInfo;
    // 查找答案选项
    let rightAnswerSort = [];
    _.filter(optionList, (optionItem, optionIndex) => {
      if (optionItem.isCorrectAnswer === 1) {
        rightAnswerSort.push(optionIndex);
      }
    });
    const textDescList = _.filter(questionAnswerDescList, (descItem) => {
      return descItem.type === "RICH_TEXT";
    });
    const pictureDescList = _.filter(questionAnswerDescList, (descItem) => {
      return descItem.type === "PICTURE";
    });
    const voiceDescList = _.filter(questionAnswerDescList, (descItem) => {
      return descItem.type === "VOICE";
    });
    const recordDescList = _.filter(questionAnswerDescList, (descItem) => {
      return descItem.type === "RECORD";
    });
    const videoDeacList = _.filter(questionAnswerDescList, (descItem) => {
      return descItem.type === "VIDEO";
    });
    return (
      <div>
        <Modal
          className="question-preview-modal"
          visible={true}
          title="题目预览"
          width={560}
          footer={null}
          onCancel={this.props.close}
        >
          <div className="question-modal-content">
            <div className="question-type">
              <div className="question-type__title">题型：</div>
              <div className="question-type__content">
                {questionTypeList[questionTypeEnum]}
              </div>
            </div>
            <div className="question-stem">
              <div className="question-stem__title">题目：</div>
              <div className="question-stem__content">
                {_.map(questionStemList, (item, index) => {
                  let dom = "";
                  let { type, content, size } = item;
                  switch (type) {
                    case "RICH_TEXT":
                      if (questionTypeEnum === "GAP_FILLING") {
                        content = content.replace(
                          /_/g,
                          `<input
                            class="add-fill-line"
                            disabled
                            answerTagList=""
                            id=${window.random_string(16)}
                            value="填空"
                          />`
                        );
                      }
                      dom = (
                        <div
                          key={index}
                          className="input-box"
                          dangerouslySetInnerHTML={{
                            __html: content,
                          }}
                        />
                      );
                      break;
                    case "PICTURE":
                      dom = (
                        <div key={index} className="picture-box">
                          <img
                            src={content}
                            onClick={() => this.handleScanFile("JPG", content)}
                          />
                        </div>
                      );
                      break;
                    case "VOICE":
                      dom = (
                        <div key={index} className="voice-box">
                          <XMAudio
                            forbidParse
                            url={content}
                            getDuration={(durationSize) => {
                              size = durationSize;
                              this.setState({});
                            }}
                            index={index}
                            size={size || 1000}
                          />
                        </div>
                      );
                      break;
                  }
                  return dom;
                })}
              </div>
            </div>
            <hr style={{ margin: "16px 0", color: "#E8E8E8", height: "1px" }} />
            {[
              "INDEFINITE_CHOICE",
              "MULTI_CHOICE",
              "SINGLE_CHOICE",
              "JUDGE",
            ].includes(questionTypeEnum) && (
              <div className="question-option">
                <div className="question-option__title">选项：</div>
                <div className="question-option__content">
                  {_.map(optionList, (optionItem, optionIndex) => {
                    const { questionOptionContentList } = optionItem;
                    const inputcontent = _.filter(
                      questionOptionContentList,
                      (optionItem) => {
                        return optionItem.type === "RICH_TEXT";
                      }
                    );
                    return (
                      <div className="option-box" key={optionIndex}>
                        <div className="option-box-header">
                          <div className="option-sort">
                            {NUM_TO_WORD_MAP[optionIndex]}.
                          </div>
                          {[
                            "INDEFINITE_CHOICE",
                            "MULTI_CHOICE",
                            "SINGLE_CHOICE",
                          ].includes(questionTypeEnum) && (
                            <div
                              className="input-box"
                              dangerouslySetInnerHTML={{
                                __html: inputcontent[0].content,
                              }}
                            />
                          )}
                          {["JUDGE"].includes(questionTypeEnum) &&
                            _.map(questionOptionContentList, (item, index) => {
                              return <span key={index}>{item.content}</span>;
                            })}
                        </div>
                        {[
                          "INDEFINITE_CHOICE",
                          "MULTI_CHOICE",
                          "SINGLE_CHOICE",
                        ].includes(questionTypeEnum) &&
                          _.map(questionOptionContentList, (item, index) => {
                            let dom = "";
                            let { type, content, size } = item;
                            switch (type) {
                              case "PICTURE":
                                dom = (
                                  <div key={index + 1} className="picture-box">
                                    <img
                                      src={content}
                                      onClick={() =>
                                        this.handleScanFile("JPG", content)
                                      }
                                    />
                                  </div>
                                );
                                break;
                              case "VOICE":
                                dom = (
                                  <div key={index + 1} className="voice-box">
                                    <XMAudio
                                      forbidParse
                                      url={content}
                                      getDuration={(durationSize) => {
                                        size = durationSize;
                                        this.setState({});
                                      }}
                                      index={index}
                                      size={size || 1000}
                                    />
                                  </div>
                                );
                                break;
                            }
                            return dom;
                          })}
                      </div>
                    );
                  })}
                </div>
              </div>
            )}
            <div className="question-answer">
              <div className="question-answer__title">答案：</div>
              {[
                "INDEFINITE_CHOICE",
                "MULTI_CHOICE",
                "SINGLE_CHOICE",
                "JUDGE",
              ].includes(questionTypeEnum) && (
                <div className="question-answer__content">
                  {_.map(rightAnswerSort, (item, index) => {
                    return (
                      <div className="option-sort" key={index}>
                        {NUM_TO_WORD_MAP[item]}
                      </div>
                    );
                  })}
                </div>
              )}
              {questionTypeEnum === "GAP_FILLING" && (
                <div className="question-gap-answer">
                  {_.map(gapFillingAnswerList, (item, index) => {
                    return (
                      <div>
                        <div className="gap-label">填空{index + 1}.</div>
                        <div className="gap-content" key={index}>
                          {_.map(
                            item.correctAnswerList,
                            (childItem, childIndex) => {
                              return <span>{childItem}</span>;
                            }
                          )}
                        </div>
                      </div>
                    );
                  })}
                </div>
              )}
            </div>
            <hr style={{ margin: "16px 0", color: "#E8E8E8", height: "1px" }} />
            <div className="question-desc">
              <div className="question-desc__title">答案解析：</div>
              <div className="question-desc__content">
                <div className="question-desc-box">
                  {textDescList.length > 0 && (
                    <div
                      className="desc-input-box"
                      dangerouslySetInnerHTML={{
                        __html: textDescList[0].content,
                      }}
                    />
                  )}
                  {pictureDescList.length > 0 && (
                    <div className="desc-picture-box">
                      {_.map(pictureDescList, (pictureItem, pictureIndex) => {
                        let { content } = pictureItem;
                        return (
                          <div className="picture-box" key={pictureIndex}>
                            <img
                              className="img-box"
                              src={content}
                              onClick={() =>
                                this.handleScanFile("JPG", content)
                              }
                            />
                          </div>
                        );
                      })}
                    </div>
                  )}
                  {recordDescList.length > 0 && (
                    <div className="desc-audio-box">
                      {_.map(recordDescList, (recordItem, recordIndex) => {
                        let { content, size } = recordItem;
                        return (
                          <div className="audio-box" key={recordIndex}>
                            <XMAudio
                              forbidParse
                              url={content}
                              getDuration={(durationSize) => {
                                size = durationSize;
                                this.setState({});
                              }}
                              index={recordIndex}
                              size={size || 1000}
                            />
                          </div>
                        );
                      })}
                    </div>
                  )}
                  {voiceDescList.length > 0 && (
                    <div className="desc-audio-box">
                      {_.map(voiceDescList, (voiceItem, voiceIndex) => {
                        let { content, size } = voiceItem;
                        return (
                          <div className="audio-box" key={voiceIndex}>
                            <XMAudio
                              forbidParse
                              url={content}
                              getDuration={(durationSize) => {
                                size = durationSize;
                                this.setState({});
                              }}
                              index={voiceIndex}
                              size={size || 1000}
                            />
                          </div>
                        );
                      })}
                    </div>
                  )}
                  {videoDeacList.length > 0 && (
                    <div className="desc-video-box">
                      {_.map(videoDeacList, (videoItem, videoIndex) => {
                        let { content } = videoItem;
                        return (
                          <div className="video-box" key={videoIndex}>
                            <img
                              className="video-box_content"
                              src={`${content}?x-oss-process=video/snapshot,t_0,m_fast`}
                            />
                            <img
                              className="video-box_btn"
                              src="https://image.xiaomaiketang.com/xm/r5H8cYm4ch.png"
                              onClick={() =>
                                this.handleScanFile("MP4", content)
                              }
                            />
                          </div>
                        );
                      })}
                    </div>
                  )}
                </div>
              </div>
            </div>
          </div>
        </Modal>
        {showScanFile && (
          <ScanFileModal
            modalTitle={scanFileType === "MP4" ? "视频播放" : "查看大图"}
            fileType={scanFileType}
            item={{
              ossAddress: scanFileAddress,
            }}
            close={() => {
              this.setState({ showScanFile: false });
            }}
          />
        )}
      </div>
    );
  }
}
export default QuestionPreviewModal;
