/*
 * @Author: yuananting
 * @Date: 2021-07-29 14:32:24
 * @LastEditors: yuananting
 * @LastEditTime: 2021-07-29 16:54:42
 * @Description: 任务中心-培训任务-新建-基本信息
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React from 'react';
import { Form, Button, Input, Space, DatePicker, Radio, Row, Col, message, Tooltip } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { withRouter } from 'react-router-dom';
// import SelectOperatorModal from '../modal/SelectOperatorModal';
// import SelectPrepareFileModal from '@/modules/prepare-lesson/modal/SelectPrepareFileModal';
import Upload from '@/core/upload';
// import GraphicsEditor from '@/modules/course-manage/components/GraphicsEditor';
// import ImgClipModal from '@/components/ImgClipModal';
import moment from 'moment';
import './BasicInfo.less';

const { TextArea } = Input;
const { RangePicker } = DatePicker;

const FormItem = Form.Item;

function BasicInfo(props) {
  const { data } = props;
  const {
    planName,
    coverUrl,
    durationType,
    endTime,
    instro,
    enableState,
    operateType,
    selectOperatorList,
    percentCompleteLive,
    percentCompleteVideo,
    percentCompletePicture,
  } = data;
  const isDefaultCover = true;

  // 使用默认封面图
  function handleResetCoverUrl() {
    // const isDefaultCover = coverUrl === defaultCover;
    // // 如果已经是默认图的话，不做任何任何处理
    // if (isDefaultCover) return;
    // message.success('已替换为默认图');
    // this.props.onChange('coverUrl', defaultCover);
    // setTimeout(() => {
    //   this.props.onChange('coverId', null);
    // }, 1000);
  }

  return (
    <div className='basic-info__form'>
      <Form labelCol={{ span: 3 }} wrapperCol={{ span: 21 }}>
        <FormItem label='培训任务名称'>
          <Input
            value={planName}
            placeholder='请输入培训任务名称（20字以内）'
            maxLength={20}
            style={{ width: 240 }}
            // onChange={(e) => this.props.onChange('planName', e.target.value)}
          />
        </FormItem>
        <FormItem label='封面图'>
          <div className='cover__wrap'>
            <div className='opt-box'>
              <Button
                onClick={() => {
                  this.setState({
                    showSelectFileModal: true,
                  });
                }}>
                上传图片
              </Button>
              <span className={`default-btn ${isDefaultCover ? 'disabled' : ''}`} onClick={handleResetCoverUrl}>
                使用默认图
              </span>
              <div className='tips'>建议尺寸1280*720px或16:9。封面图最大5M，支持jpg、jpeg和png。</div>
            </div>
            <div className='img-box'>
              {isDefaultCover && <span className='tag'>默认图</span>}
              <img src={coverUrl} width='690' alt='' />
            </div>
          </div>
        </FormItem>
        <FormItem label='培训时间'>
          <div className='duration__wrap'>
            <Radio.Group value={durationType} onChange={(e) => props.onChange('durationType', e.target.value)}>
              <Space direction='vertical'>
                <Radio value='NEVER_EXPIRES'>
                  永久有效<span className='tips'>设置为“永久有效”，发布后任务开始生效，取消发布后失效</span>
                </Radio>
                <Radio value='FIXED_DURATION'>
                  固定时间段
                  <div className='picker-box'>
                    <RangePicker
                      style={{ width: 320 }}
                      showTime={{ defaultValue: [moment().add(10, 'minutes'), moment().add(10, 'minutes')] }}
                      ranges={{
                        近7天: [moment().add(10, 'minute'), moment().add(6, 'day').endOf('day')],
                        近1个月: [moment().add(10, 'minute'), moment().add(1, 'month').endOf('day')],
                        近3个月: [moment().add(10, 'minute'), moment().add(3, 'month').endOf('day')],
                      }}
                      disabled={durationType === 'NEVER_EXPIRES'}
                      // disabledDate={disabledDate}
                      // value={[examStartTime ? moment(Number(examStartTime)) : null, examEndTime ? moment(Number(examEndTime)) : null]}
                      // disabledTime={disabledRangeTime}
                      format='YYYY-MM-DD HH:mm'
                      // onChange={(date) => {
                      //   setStartTime(date && date[0]?.valueOf());
                      //   setExamEndTime(date && date[1]?.valueOf());
                      // }}
                    />
                  </div>
                </Radio>
              </Space>
            </Radio.Group>
          </div>
        </FormItem>
        <FormItem label='学习模式'>
          <div className='learning-model__wrap'>
            <Radio.Group value={durationType} onChange={(e) => props.onChange('durationType', e.target.value)}>
              <Radio value='FREE_LEARNING'>自由学习</Radio>
              <Radio value='BREAKTHROUGH_LEARNING'>
                闯关学习
                <Tooltip title='提示：任务开始后学习模式将不允许更换'>
                  <i
                    className='icon iconfont'
                    style={{
                      marginLeft: '5px',
                      cursor: 'pointer',
                      color: '#bfbfbf',
                      fontSize: '14px',
                      fontWeight: 'normal',
                    }}>
                    &#xe61d;
                  </i>
                </Tooltip>
              </Radio>
            </Radio.Group>
          </div>
        </FormItem>
        <FormItem label='指派学员'>
          <Button>
            <PlusOutlined />
            添加指派对象
          </Button>
        </FormItem>
      </Form>
    </div>
  );
}

export default BasicInfo;
