/*
 * @Author: 吴文洁 
 * @Date: 2020-05-19 11:01:31 
 * @Last Modified by: chenshu
 * @Last Modified time: 2021-03-24 15:13:38
 * @Description 余额异常弹窗
 */
import React from 'react';
import {Table, Modal,Input} from 'antd';
import { PageControl } from "@/components";
import Service from "@/common/js/service";
import User from '@/common/js/user'
import './WatchDataModal.less';
import dealTimeDuration from "../../utils/dealTimeDuration";

const { Search } = Input;
class WatchDataModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      visible:true,
      dataSource:[],
      size:10,
      query: {
        current: 1,
      },
      totalCount:0
    };
  }
  componentDidMount() {
    this.handleFetchDataList();
  }

  onClose = () =>{
    this.props.close();
  }

   // 获取观看视频数据列表
  handleFetchDataList = () => {
    const {query,size,totalCount} = this.state
    const { id } = this.props.data;

    const params ={
      ...query,
      size,
      courseId:id,
      storeId:User.getStoreId()
    }
    Service.Hades('public/hades/mediaCourseWatchInfo', params).then((res) => {
      const { result = {} } = res ;
      const { records = [], total = 0 } = result;
      this.setState({
        dataSource: records,
        totalCount: Number(total)
      });
    });
  }
  handleChangNickname = (value)=>{
    const isPhone = (value || '').match(/^\d+$/);
    const { query } =  this.state;
    if(isPhone){
      query.phone = value;
      query.nickName = null;
    }else{
      query.nickName = value;
      query.phone = null;
    }
    query.current = 1;
    this.setState({
      query
    })
  }

  onShowSizeChange = (current, size) => {
    if (current == size) {
      return
    }
    this.setState({
      size
    },()=>{this.handleFetchDataList()})
  }

  // 请求表头
  parseColumns = () => {
    const columns = [
      {
        title: '观看用户',
        key: 'name',
        dataIndex: 'name'
      },
      {
        title: '手机号',
        key: 'phone',
        dataIndex: 'phone'
      },
      {
        title: '观看者类型',
        key: 'userRole',
        dataIndex: 'userRole'
      },
      {
        title: '首次观看时间',
        key: 'firstWatch',
        dataIndex: 'firstWatch',
        render: (val) => {
          return formatDate('YYYY-MM-DD H:i', val) 
        }
      },
      {
        title: '观看总时长',
        key: 'watchDuration',
        dataIndex: 'watchDuration',
        render: (val) => {
          return  <span>{val ? dealTimeDuration(val) : "00:00:00" }</span>
        }
      },
      {
        title: '学习进度',
        key: 'progress',
        dataIndex: 'progress',
        render: (val) => {
          return  <span>{val || 0}%</span>
        }
      }
    ];
    return columns;
  }

  render() {
    const { visible,size,dataSource,totalCount,query} = this.state;
    return (
        <Modal
          title="图文课观看数据"
          visible={visible}
          footer={null}
          onCancel={this.onClose}
          maskClosable={false}
          className="watch-data-modal"
          closable={true}
          width={800}
          closeIcon={<span className="icon iconfont modal-close-icon">&#xe6ef;</span>}
        >
          <div className="search-container">
            <Search placeholder="搜索用户姓名/手机号"  style={{ width: 200 }}  onChange={(e) => { this.handleChangNickname(e.target.value)}}  onSearch={ () => { this.handleFetchDataList()}} enterButton={<span className="icon iconfont">&#xe832;</span>}/>
          </div>
          <div>
            <Table
              rowKey={record => record.id}
              dataSource={dataSource}
              columns={this.parseColumns()}
              pagination={false}
              bordered
            />
            {dataSource.length >0 &&
              <div className="box-footer">
                <PageControl
                  current={query.current - 1}
                  pageSize={size}
                  total={totalCount}
                  size="small"
                  toPage={(page) => {
                    const _query = {...query, current: page + 1};
                    this.setState({
                      query:_query
                    },()=>{ this.handleFetchDataList()})
                  }}
                  onShowSizeChange={this.onShowSizeChange}
                />
              </div>
            }
          </div>
        </Modal>
    )
  }
}

export default WatchDataModal;