/*
 * @Author: 吴文洁 
 * @Date: 2019-09-25 18:07:33 
 * @Last Modified by: 吴文洁
 * @Last Modified time: 2020-02-25 15:50:29
 * @Descript: 会员宝相关常量
 */
import Enum from '@/core/enum';

const PointsExchangeStatus = new Enum([{
  key: 'WATING_AUDIT',
  id: 'WATING_AUDIT',
  value: '待审核',
  name: '待审核',
  color: '#FF8534'
}, {
  key: 'USER_CANCEL',
  id: 'USER_CANCEL',
  value: '已撤销',
  name: '已撤销',
  color: '#999'
}, {
  key: 'WATING_DELIVER',
  id: 'WATING_DELIVER',
  value: '待发放',
  name: '待发放',
  color: '#58B7EF'
}, {
  key: 'FINISH_DELIVER',
  id: 'FINISH_DELIVER',
  value: '已发放',
  name: '已发放',
  color: '#3BBDAA'
}]);

const orderStateMap = {
  'WATING_AUDIT': '待审核',
  'USER_CANCEL': '已撤销',
  'WATING_DELIVER': '待发放',
  'FINISH_DELIVER': '已发放'
}

export {
  PointsExchangeStatus,
  orderStateMap
}