import React from 'react';
import { withRouter } from "react-router-dom";
import { Tabs } from 'antd';

import Breadcrumbs from "@/components/Breadcrumbs";
import CourseData from './CourseData';
import PlaybackData from './PlaybackData';



import './DataList.less';


class DataList extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      
    }
  }

  render() {
    return (
      <div className="page data-list">
        <Breadcrumbs
          navList="上课数据"
          goBack={() => {
            console.log("准备返回");
            RCHistory.goBack();
          }}
        />
        <div className="box">
          <Tabs defaultActiveKey="courseData" >
            <Tabs.TabPane tab="上课记录" key="courseData">
              <CourseData></CourseData>
            </Tabs.TabPane>

            <Tabs.TabPane tab="回放记录" key="playbackData">
              <PlaybackData></PlaybackData>
            </Tabs.TabPane>
          </Tabs>
        </div>

      </div>
    )
  }
}

export default withRouter(DataList);