/*
 * @Author: yuananting
 * @Date: 2021-03-29 10:52:26
 * @LastEditors: yuananting
 * @LastEditTime: 2021-04-07 15:23:06
 * @Description: 助学工具-试卷-新建选择题目弹窗
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { Component } from "react";
import { Modal } from "antd";
import CourseCategorySiderTree from "../../components/CourseCategorySiderTree";
import SelectQuestionList from "../components/SelectQuestionList";
import "./SelectQuestionModal.less";

class SelectQuestionModal extends Component {
  listRef = React.createRef();
  constructor(props) {
    super(props);
    this.state = {
      selectedCategoryId: null,
    };
  }

  componentDidMount() {
    this.listRef.current.state.selectQuestionKeys = this.props.getSelectedQuestion.map(
      (item) => {
        item.id = item.questionId;
        item.questionTypeEnum = item.questionType;
        return item;
      }
    );
  }

  render() {
    return (
      <Modal
        className="select-question-modal"
        destroyOnClose={true}
        title="选择题目"
        visible={true}
        width={1080}
        onOk={() => {
          this.props.setSelectedQuestion(
            this.listRef.current.state.selectQuestionKeys.map((item) => {
              item.questionId = item.id || item.questionId;
              item.questionType = item.questionTypeEnum || item.questionType;
              item.score = item.score || 2;
              if (
                ["MULTI_CHOICE", "GAP_FILLING", "INDEFINITE_CHOICE"].includes(
                  item.questionTypeEnum
                )
              ) {
                item.portionScore = item.portionScore || 0;
              }
              return item;
            })
          );
        }}
        onCancel={this.props.close}
      >
        <div className="box content-body" style={{maxHeight:500}}>
          <div
            style={{ borderRight: "0.5px solid #EEEEEE", paddingRight: "4px",overflowY:'auto',overflowX:'hidden'}}
          >
            <div className="sider">
              <CourseCategorySiderTree fromModule="QUESTION_MODAL" />
            </div>
          </div>
          <div className="content" style={{height:'auto',overflowY:'auto'}}>
            <SelectQuestionList ref={this.listRef} />
          </div>
        </div>
      </Modal>
    );
  }
}

export default SelectQuestionModal;
