import React from 'react';

import GraphicsCourseFilter from './components/GraphicsCourseFilter';
import GraphicsCourseOpt from './components/VieoCourseOpt';
import GraphicsCourseList from './components/GraphicsCourseList';
import CourseService from "@/domains/course-domain/CourseService";
import User from '@/common/js/user'

class GraphicsCourse extends React.Component {

  constructor(props) {
    super(props);
    this.state = {
      query: {
        size: 10,
        current: 1,
        storeId:User.getStoreId()
      },
      dataSource: [],    // 视频课列表
      totalCount: 0,     // 视频课数据总条数
    }
  }

  componentWillMount() {
    // 获取视频课列表
    this.handleFetchScheduleList();
  }

  // 获取视频课列表
  handleFetchScheduleList = (_query = {}) => {
    const query = {
      ...this.state.query,
      ..._query
    };

    // 更新请求参数
    this.setState({ query });

    CourseService.videoSchedulePage(query).then((res) => {
      const { result = {} } = res || {};
      const { records = [], total = 0 } = result;
      this.setState({
        dataSource: records,
        totalCount: Number(total)
      });
    });
  }

  render() {
    const { dataSource, totalCount, query } = this.state;
    return (
      <div className="page video-course-page">
        <div className="content-header">图文课</div>

        <div className="box">
          {/* 搜索模块 */}
          <GraphicsCourseFilter
            onChange={this.handleFetchScheduleList}
          />

          {/* 操作模块 */}
          <GraphicsCourseOpt />
          
          {/* 视频课列表模块 */}
          <GraphicsCourseList
            query={query}
            dataSource={dataSource}
            totalCount={totalCount}
            onChange={this.handleFetchScheduleList}
          />
        </div>
      </div>
    )
  }
}

export default GraphicsCourse;
