import React from 'react';
import {Table, Modal,Input} from 'antd';
import { PageControl } from "@/components";
import PlanService from '@/domains/plan-domain/planService'
import User from '@/common/js/user'
import './SelectOperatorModal.less';
import _ from "underscore";
const { Search } = Input;
class RelatedPlanModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      dataSource:[],
      size:10,
      query: {
        current: 1,
      },
      totalCount:0,
    };
  }
  componentDidMount() {
    this.handleFetchDataList();
  }
 
   // 获取运营师列表
  handleFetchDataList = () => {
    const {query,size,totalCount} = this.state
    const params ={
      ...query,
      size,
      storeId:User.getStoreId()
    }
    PlanService.getStorePlanAll(params).then((res) => {
      const { result = {} } = res ;
      const { records = [], total = 0 } = result;
      this.setState({
        dataSource: records,
        totalCount: Number(total)
      });
    });
  }
  handleChangePlanName = (value)=>{
    query.planName = value;
    query.current = 1;
    this.setState({
      query
    })
  }

  onShowSizeChange = (current, size) => {
    if (current == size) {
      return
    }
    this.setState({
      size
    },()=>{this.handleFetchDataList()})
  }

  // 请求表头
  parseColumns = () => {
    const columns = [
      {
        title: '培训计划',
        key: 'planName',
        dataIndex: 'planName'
      }
    ];
    return columns;
  }

  render() {
    const { size,dataSource,totalCount,query,selectOperatorList} = this.state;
    const { visible } = this.props;
    return (
        <Modal
          title="关联培训计划"
          onCancel={this.props.onClose}
          maskClosable={false}
          visible={visible}
          className="related-plan-modal"
          closable={true}
          width={800}
          onOk={() => this.props.onSelect(selectOperatorList) } 
          closeIcon={<span className="icon iconfont modal-close-icon">&#xe6ef;</span>} 
        >
          <div className="search-container">
            <Search placeholder="搜索培训计划名称"  style={{ width: 200 }}  onChange={(e) => { this.handleChangePlanName(e.target.value)}}  onSearch={ () => { this.handleFetchDataList()}} />
          </div>
          <div>
            <Table
              rowKey={record => record.planId}
              dataSource={dataSource}
              columns={this.parseColumns()}
              pagination={false}
             
            />
            {dataSource.length >0 &&
              <div className="box-footer">
                <PageControl
                  current={query.current - 1}
                  pageSize={size}
                  total={totalCount}
                  toPage={(page) => {
                    const _query = {...query, current: page + 1};
                    this.setState({
                      query:_query
                    },()=>{ this.handleFetchDataList()})
                  }}
                  onShowSizeChange={this.onShowSizeChange}
                />
              </div>
            }
          </div>
        </Modal>
    )
  }
}

export default RelatedPlanModal;