/*
 * @Author: wufan
 * @Date: 2020-07-09 14:03:09
 * @Last Modified by: mikey.zhaopeng
 * @Last Modified time: 2020-11-28 13:53:12
 * 店铺管理-员工管理
 */
import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import _ from "underscore";
import PageControl from "@/components/PageControl";
import { Button, Table,Modal,message} from "antd";
import { QuestionCircleOutlined } from '@ant-design/icons';
import StoreService from "@/domains/store-domain/storeService";
import CatalogAddOrEditModal from './modal/CatalogAddOrEditModal';
import SecondCatalogAddOrEditModal from './modal/SecondCatalogAddOrEditModal';
import "./CourseCatalogPage.less";
import User from '@/common/js/user';
const { confirm } = Modal;
interface RecordTypes {
  sonCategoryList: any;
}

function CourseCatalogPage() {
  const [courseCatalogList, setCourseCatalogList] = useState([]);

  const [query, setQuery] = useState({
    current: 0,
    size: 10,
    storeId: User.getStoreId(),
  });
  
  const [total, setTotal] = useState(0);
  const [catalogModalVisible,setCatalogModalVisible] = useState(false);
  const [catalogModalType,setCatalogModalType] = useState('');
  const [secondCatalogModalVisible,setSecondCatalogModalVisible] = useState(false);
  const [secondCatalogModalType,setSecondCatalogModalType] = useState('');
  const [parentCatalogId,setParentCatalogId] = useState('');
  const [choosedItem, setChooseItem] = useState({});
  useEffect(() => {
    getCourseCatalogList();
  }, [query]);

  function addCatalog(){
    setChooseItem({});
    setCatalogModalVisible(true) ;
    setCatalogModalType('add');
  }
  function addSecondCatalog(record:any){
    setChooseItem({});
    setParentCatalogId(record.id);
    setSecondCatalogModalVisible(true);
    setSecondCatalogModalType('add');
  }
  function deleteCatalog(record:any){
    return  confirm({
      title: record.type==='parent'? '你确定要删除此分类吗？':'你确定要删除此子分类吗？',
      content: record.type==='parent'? '删除后，此分类下包含的所有子分类都会被删除，此操作不可恢复。':'此操作不可恢复。',
      icon: <QuestionCircleOutlined />,
      okText: '删除',
      okType: 'danger',
      cancelText: '取消',
      onOk: () => {
        handleDeleteCatalog(record);
      }
    })
  }

  function handleDeleteCatalog(record:any) {
    const param ={
      categoryId:record.id
    }
    StoreService.delCourseCategory(param).then((res: any) =>{
      getCourseCatalogList();
      message.success("分类已删除");
    });
  }
  function parseColumn():any{
    return [
        { title: '分类名称', 
          dataIndex: 'categoryName', 
          key: 'categoryName',
        },
        {
          title: '操作',
          dataIndex: 'action',
          key: 'action',
          width:300,
          render: (val: string, record: any) => {
            return (
              <div className="operation">
                  { record.type==="parent" && 
                    <>
                      <span
                        className="add-btn"
                        onClick={() => { addSecondCatalog(record) }}
                      >
                        添加子分类
                      </span>
                      <span className="divider-line">{" | "}</span>
                    </>
                  }
                 
                  <span className="edit-btn"
                    onClick={()=>{editCatalog(record)}}
                  >    
                  编辑
                  </span>
                  <span className="divider-line" >{" | "}</span>
                  <span  className="delete-btn" onClick={()=>{deleteCatalog(record)}}
                  >
                    删除
                  </span>
            </div>
            )

          },
        },
    ]
  }
  function getCourseCatalogList():any {
    let _query = _.clone(query);
    _query.current = query.current + 1;
    StoreService.getCourseCatalogList(_query).then((res: any) => {
      let resultData = handleCatalogListData(res.result.records)
      setCourseCatalogList(resultData);
      setTotal(res.result.total);
    });
  }

  function handleCatalogListData(listData:any){
    listData.map((item:any,index:any) => {
      item.type = "parent"
      item.key = item.id;
      if(item.sonCategoryList){
        item.sonCategoryList.map((_item:any,_index:any) =>{
          _item.type = "child";
          _item.key=_item.id
          return _item
        });
      }
      return item
    })
    return listData
  }

  function editCatalog(record:any){
    if(record.type ==="parent"){
      setCatalogModalType('edit');
      setCatalogModalVisible(true);
    }else{
      setParentCatalogId(record.parentId)
      setSecondCatalogModalType('edit');
      setSecondCatalogModalVisible(true);
    }
    setChooseItem(record);
  }
  return (
    <div className=" page course-catalog-page">
      <div className="page-content">
        <div className="content-header">员工管理</div>
        <div className="box">
          <div className="box-header">
            <Button
              type="primary"
              className="add-show-btn"
              onClick={() => {addCatalog()}}
            >
              添加分类
            </Button>
          </div>
          <div className="box-body">
            <Table
                columns={ parseColumn() }
                pagination={false}
                expandedRowRender={(record:RecordTypes) => {
                  if(!record.sonCategoryList){
                    return <div>还未添加任何子分类</div>;
                  }
                  if (record.sonCategoryList.length !== 0){
                    return <Table columns={parseColumn()} dataSource={record.sonCategoryList} pagination={false}   className="child-table"/>
                  }else{
                    return <div className="empty-child">还未添加任何子分类</div>;
                  }
                }}
                dataSource={courseCatalogList}
            />
          </div>
          <div className="box-footer">
            <PageControl
               current={query.current}
               pageSize={query.size}
               total={total}
               toPage={(page: any) => {
                 const queryStates = _.clone(query);
                 queryStates.current = page;
                 setQuery(queryStates);
               }}
              
            />
          </div>
        </div>
        {
          catalogModalVisible && <CatalogAddOrEditModal modalType={catalogModalType} onClose={()=>{setCatalogModalVisible(false)}} refreshCatalogList={getCourseCatalogList} choosedItem={choosedItem}/>
        }
        {
          secondCatalogModalVisible && <SecondCatalogAddOrEditModal modalType={secondCatalogModalType} parentId={parentCatalogId} onClose={()=>{setSecondCatalogModalVisible(false)}} choosedItem={choosedItem} refreshCatalogList={getCourseCatalogList} />
        }
      </div>
    </div>
  );
}

export default withRouter(CourseCatalogPage);
