/*
 * @Author: yuananting
 * @Date: 2021-07-28 11:25:58
 * @LastEditors: yuananting
 * @LastEditTime: 2021-08-05 16:33:23
 * @Description: 任务中心-培训任务
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { useEffect, useState } from 'react';
import TrainFilter from './components/TrainFilter';
import { Route, withRouter } from 'react-router-dom'
import TrainList from './components/TrainList';
// import PlanList from './components/PlanList'
import PlanService from '@/domains/plan-domain/planService';
import DataCenter from '../data-center/Index';
import User from '@/common/js/user';
function TrainTaskPage(props) {
  const [trainListData, setTrainListData] = useState([]); // 培训任务列表
  const [query, setQuery] = useState({
    issueState: 'ALL', // 发布状态
    myAssist: false, // 是否协同
    current: 1,
    size: 10,
    storeUserId: User.getStoreUserId(),
  });
  const [totalCount, setTotalCount] = useState(0); // 总数
  const { match } = props;

  useEffect(() => {
    handleFetchTrainList();
  }, [query]);

  //动态获取计划列表
  function handleFetchTrainList() {
    PlanService.getTrainingPlanPage(query).then((res) => {
      const {
        result: { records = [], total },
      } = res;
      setTrainListData(records);
      setTotalCount(total);
    });
  }

  // 搜索条件修改
  function queryChange(_query) {
    setQuery({ ...query, ..._query });
  }

  return (
    <div className='page'>
      <div className='content-header'>培训任务</div>
      <div className='box'>
        <TrainFilter onChange={queryChange} />
        <TrainList trainListData={trainListData} query={query} totalCount={totalCount} onChange={queryChange} />
      </div>
      <Route path={`${match.url}/data`} component={DataCenter} />
    </div>
  );
}
export default withRouter(TrainTaskPage);
