/*
 * @Author: yuananting
 * @Date: 2021-08-05 17:09:36
 * @LastEditors: yuananting
 * @LastEditTime: 2021-08-05 19:43:57
 * @Description: 新建培训任务-选择指派对象
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React from 'react';
import { Modal, Input, message, Tooltip, AutoComplete, Tabs } from 'antd';
import { XMTable } from '@/components';
// import college from '@/common/lottie/college.json';
// import Service from '@/common/js/service';
// import User from '@/common/js/user';
// import SetEmployeeModal from './SetEmployeeModal';
// import search from '../../lottie/search/data.json';
// import MemberTree from '../components/MemberTree';
// import { DepType } from '@/domains/store-domain/constants';
// import StoreService from '@/domains/store-domain/storeService';
// import SearchUser from '../components/SearchUser';
// import WWOpenDataCom from '@/components/WWOpenDataCom';
// import './ChooseMembersModal.less';
// import _ from 'underscore';

const { Search } = Input;
const { TabPane } = Tabs;

class ChooseAssignorModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      selectUserList: [],
      selectObject: {},
      openSetModal: false,
      visible: this.props.visible,
      completeOptions: [],
      queryName: '',
      open: false,
      searchUserResultList: {},
    };
  }
  componentDidMount() {}
  handleClose = () => {
    this.props.close();
  };

  // 信息列表——右边
  selectedColumnsRight = () => {
    const selectColumns = [
      {
        title: '学员名',
        key: 'nameRight',
        dataIndex: 'userName',
        width: '70%',
        render: (value, record) => {
          const { userName = '', avatar } = record;
          return (
            <div className='avatar'>
              <span className='icon iconfont avatar-icon'>&#xe84a;</span>
              <Tooltip title={userName}>
                <span className='userImg'>
                  {/* <WWOpenDataCom type='userName' openid={userName} /> */}
                  {/* {userName} */}
                </span>
              </Tooltip>
            </div>
          );
        },
      },
      {
        title: '操作',
        key: 'edit',
        dataIndex: 'edit',
        width: '30%',
        align: 'right',
        render: (value, record) => {
          return (
            <div className='edit' onClick={() => this.clearOneUser(record)}>
              <span className='icon iconfont edit-icon'>&#xe717;</span>
            </div>
          );
        },
      },
    ];
    return selectColumns;
  };

  treeSelect = (record) => {
    // console.log('record',record)
    this.setState({
      selectUserList: record,
    });
  };

  clearOneUser = (record) => {
    console.log('record', record);
    const { selectUserList } = this.state;
    const _selectUserList = selectUserList.filter((item, index) => {
      return item.userId !== record.userId;
    });
    console.log('selectUserList', selectUserList);
    this.setState({
      selectUserList: _selectUserList,
    });
  };
  // 清空所有成员
  clearAllUser = () => {
    this.setState({
      selectUserList: [],
    });
  };

  addCustomer = () => {
    const { selectUserList } = this.state;
    const { addDepType } = this.props;
    let enterpriseUserList = []; // 保存新加进去的成员
    enterpriseUserList = selectUserList.map((item) => {
      const _item = {};
      if (addDepType === 'DEP_ORG') {
        _item.depUserType = 'VISIBLE_USER';
        _item.departmentId = item.departmentId;
        _item.enterpriseVisibleUserId = item.userId;
      } else {
        _item.depUserType = 'STORE_USER';
        _item.departmentId = this.props.selectDep.id;
        _item.enterpriseVisibleUserId = item.enterpriseUserId;
      }
      return _item;
    });
    const _params = {
      storeId: User.getStoreId(),
      depType: addDepType,
      userAndDepartmentList: enterpriseUserList,
    };
    Service.Hades('public/hades/addBatchUserAndDepartmentStoreCustomer', _params).then((res) => {
      this.handleClose();
      this.props.onConfirm();
    });
  };

  // 批量添加成员(点击确定)
  addUser = (selectUserList) => {
    let enterpriseUserList = []; // 保存新加进去的成员
    selectUserList.map((item) => {
      enterpriseUserList.push({
        roleCode: item.roleCode,
        enterpriseVisibleUserId: item.userId,
      });
      return enterpriseUserList;
    });
    const _params = {
      storeId: User.getStoreId(),
      enterpriseUserList,
    };
    Service.Hades('public/hades/addBatchEnterpriseStoreUser', _params).then((res) => {
      if (res.code === '200') {
        this.props.onConfirm();
        this.setState({
          openSetModal: false,
        });
      }
    });
  };

  renderTitle = (title) => {
    return <span>{title}</span>;
  };
  renderItem = (record, type) => ({
    value: record.userName || record.name,
    label: (
      <div
        style={{
          display: 'flex',
          justifyContent: 'space-between',
        }}>
        {type === 'user' ? <div>{record.userName}</div> : <div>{record.name}</div>}
        {type === 'user' &&
          record.postDepNamesList.map((item, index) => {
            return <span>{item}</span>;
          })}
        {type === 'post' && <span>{item.parentName}</span>}
      </div>
    ),
  });
  notFoundContentNode = () => {
    return <span>暂无数据</span>;
  };
  Complete = () => {
    const { open, completeOptions, queryName } = this.state;
    return (
      <AutoComplete
        dropdownClassName='certain-category-search-dropdown'
        dropdownMatchSelectWidth={250}
        allowClear
        onChange={(value) => {
          this.getCompleteOptionData(value);
        }}
        notFoundContent={() => {
          this.notFoundContentNode();
        }}
        value={queryName}
        open={open}
        onFocus={() => {
          this.setState({ open: true });
        }}
        onBlur={() => {
          this.setState({ open: false });
        }}
        style={{
          width: 250,
        }}
        options={completeOptions}
        onSelect={() => this.confirmSearchSelect()}
        placeholder='搜索员工、部门'></AutoComplete>
    );
  };
  getCompleteOptionData = (value) => {
    if (!value) {
      this.setState({
        searchUserResultList: {},
      });
      return;
    }
    this.setState({
      queryName: value,
    });
    const params = {
      distinct: true,
      queryType: this.props.type,
      depType: this.props.treeDepType,
      queryName: value,
      enterpriseId: User.getEnterpriseId(),
      source: 0, //0代表来自企培
      storeId: User.getStoreId(),
      userId: User.getUserId(),
      whetherCount: false,
    };
    StoreService.getDepartmentUser(params).then((res) => {
      const { result = {} } = res;
      this.setState({
        searchUserResultList: result,
      });
    });
  };

  confirmSearchSelect = (record, type) => {
    const { selectUserList } = this.state;
    if (type === 'user') {
      this.setState({ selectUserList: [...selectUserList, ...record] });
    } else {
      let _list = [];
      if (record.departmentUserVOList) {
        _list = record.departmentUserVOList;
      }
      console.log('_list', _list);
      this.setState({ selectUserList: [...selectUserList, ..._list] }, () => {
        console.log('selectUserList', this.state.selectUserList);
      });
    }
  };

  render() {
    const { type, treeDepType, selectDep = {}, addDepType = '' } = this.props;
    const { id = '' } = selectDep;
    const { selectUserList, selectObject, visible, openSetModal, searchUserResultList } = this.state;
    const title = type === 'USER' ? '添加员工' : '添加学员';
    return (
      <Modal title='添加指派对象' visible={true}>
        <div className='choose-container'>
          <div className='container-left'>
            <Tabs>
              <TabPane label='部门'></TabPane>
              <TabPane label='岗位'></TabPane>
              <TabPane label='自定义分组'></TabPane>
            </Tabs>
          </div>
          <div className='container-right'></div>
          <div></div>
        </div>
      </Modal>
    );
  }
}

export default ChooseAssignorModal;
