
import Bus from './bus';

class routeHook {
    constructor() {
        this.routeFun = [];
        this.callBacks = []
    }



    add(callback) {  //切换路由之前添加的函数
        this.routeFun = [callback]
    }

    addJump(callback) {
        this.callBacks = [callback]
    }


    pop() { //去除回调
        this.routeFun.pop();
    }

    cancel() {  //取消跳转
        console.log('jhgjh')
        this.routeFun.pop()
    }


    break() {  //切换路由是执行的函数
        const enterFun = this.routeFun[0];
        enterFun && enterFun()
    }

    leave() { //切换路由
        const callBacks = this.callBacks.pop();
        callBacks && callBacks()
        this.routeFun = [];
    }

    //离开保存时的特例
    // **

    addSaveCase() { //离开保存校验时将方法注入
        setTimeout(()=>{
            this.add(this.saveBeforeLeave.bind(this))
        },100)
       
    }

    saveBeforeLeave() { //离开保存时触发的方法
        Bus.trigger('showRouteChangeModal')
    }

    //** */

    getCallbackNum() {
        return this.routeFun.length
    }

}


export default new routeHook()