import React, { useState, useRef, useEffect, useContext } from 'react'
import Breadcrumbs from "@/components/Breadcrumbs";
import { Form, Alert, Input, Button, InputNumber, DatePicker } from 'antd';
import { Route, withRouter } from 'react-router-dom';
import moment from 'moment'
import GraphicsEditor from '../../course-manage/components/GraphicsEditor';
import SelectPaperModal from './SelectPaperModal'
import './AddExam.less';

const { RangePicker } = DatePicker;

function AddExam(props: any) {
    const paperInfoInit: any = { passScore: 60 };
    const [showModal, setShowModal] = useState(false);
    const [paperInfo, setPaperInfo] = useState(paperInfoInit);
    const [paperId, setPaperId] = useState('');
    const [passRate, setPassRate] = useState(60);//及格线
    const [startTime, setStartTime] = useState('');
    const [examEndTime, setExamEndTime] = useState('');
    const [examName, setExamName] = useState('');
    const [examDuration, setExamDuration] = useState(0);
    useEffect(() => {
        console.log(paperInfo)
        setPaperId(paperInfo.paperId)
        setPassRate(paperInfo.passScore)

    }, [paperInfo.paperId])

    function disabledDate(current: any) {
        // Can not select days before today and today
        return current && current < moment().startOf('day');
    }


    function disabledRangeTime(date: any, type: any) {

        if (moment(date).isSame(moment(), 'day')) {
            return {
                disabledHours: () => {
                    const hours = [];
                    for (let i = 0; i < moment().hour(); i++) {
                        hours.push(i);
                    }
                    return hours;
                },
                disabledMinutes: () => {
                    const currentMinute = moment().minute();
                    const currentHour = moment(date).hour();
                    const minutes = [];
                    if (currentHour === moment().hour()) {
                        for (let i = 0; i < currentMinute; i++) {
                            minutes.push(i);
                        }
                    }
                    return minutes;
                },

            };
        }
        return {
            disabledHours: () => [],
            disabledMinutes: () => [],
            disabledSeconds: () => [],
        };
    }

    return <div className="page examPage">
        <Breadcrumbs navList={"新建考试"} goBack={() => props.history.goBack()} />

        <div className="box">
            <Alert message="请遵守国家相关规定，切勿上传低俗色情、暴力恐怖、谣言诈骗、侵权盗版等相关内容，小麦企培保有依据国家规定及平台规则进行处理的权利" type="info" showIcon />
            <div className="form">
                <div className="title">基本信息</div>
                <Form
                    labelCol={{ span: 3 }}
                    wrapperCol={{ span: 14 }}
                    layout="horizontal"
                >
                    <Form.Item label="考试名称" name="size" required>
                  
                        <Input placeholder='请输入试卷名称（40字以内）' value={examName} onChange={(e) => { 
                            console.log(e.target.value)
                            setExamName(e.target.value) }} style={{ width: 300 }} />
                    </Form.Item>

                    <Form.Item label="选择试卷" name="size" required>
                        <span style={{ marginRight: 12, lineHeight: '32px' }}>{paperInfo.paperName}</span>  <Button onClick={() => { setShowModal(true) }} >{paperInfo.paperId ? '重新选择' : '选择试卷'}</Button>


                    </Form.Item>

                    {
                        paperInfo.paperId && <div className="table">
                            <div className="header">
                                <div className="item">单选题</div>
                                <div className="item">多选题</div>
                                <div className="item">判断题</div>
                                <div className="item">填空题</div>
                                <div className="item">不定项选择题</div>
                                <div className="item">合计</div>
                            </div>
                            <div className="body-list">
                                <div className="item">{paperInfo.singleChoiceCnt || 0}题</div>
                                <div className="item">{paperInfo.multiChoiceCnt || 0}题</div>
                                <div className="item">{paperInfo.judgeCnt || 0}题</div>
                                <div className="item">{paperInfo.gapFillingCnt || 0}题</div>
                                <div className="item long">{paperInfo.indefiniteChoiceCnt || 0}题</div>
                                <div className="item">{paperInfo.singleChoiceCnt + paperInfo.multiChoiceCnt + paperInfo.judgeCnt + paperInfo.gapFillingCnt + paperInfo.indefiniteChoiceCnt || 0}题</div>
                            </div>
                            <div className="body-list">
                                <div className="item">{paperInfo.singleChoiceCnt || 0}分</div>
                                <div className="item">{paperInfo.multiChoiceCnt || 0}分</div>
                                <div className="item">{paperInfo.judgeCnt || 0}分</div>
                                <div className="item">{paperInfo.gapFillingCnt || 0}分</div>
                                <div className="item long">{paperInfo.indefiniteChoiceCnt || 0}分</div>
                                <div className="item">{paperInfo.totalScore || 0}分</div>
                            </div>
                        </div>
                    }


                    <Form.Item label="及格线" name="size" required>
                        <InputNumber value={passRate} onChange={(value: any) => { setPassRate(value) }} style={{ width: 100 }} />
                        <span style={{ marginLeft: 4 }}>%
                        </span>
                        <span style={{ marginLeft: 20, color: "#999" }}>
                            {`  总分(${paperInfo.totalScore || 0})*及格线（${passRate || 0}%）=及格分数（${parseInt(((paperInfo.totalScore || 0) * (passRate || 0)) as any / 100 + '')}）`}</span>
                    </Form.Item>

                    <Form.Item label="考试有效期" name="size" required>
                        {/* <RangePicker
                            ranges={{
                                '近七天': [moment(), moment().add(6, 'day').endOf('day')],
                                '近1个月': [moment(), moment().add(1, 'month').endOf('day')],
                                '近3个月': [moment(), moment().add(3, 'month').endOf('day')],
                            }}
                            disabledDate={disabledDate}
                            // value={[
                            //     startTime ? moment(Number(startTime)) : null,
                            //     examEndTime ? moment(Number(examEndTime)) : null
                            // ]}
                            disabledTime={disabledRangeTime}
                            showTime
                            format="YYYY/MM/DD HH:mm"
                            onChange={(date: any) => {
                                setStartTime(date && date[0]?.startOf('day').valueOf());
                                setExamEndTime(date && date[1]?.endOf('day').valueOf());

                            }}
                        /> */}
                    </Form.Item>
                    <Form.Item label="开始时长" name="size" required>
                        <InputNumber value={examDuration} max={1440} min={1} onChange={(value: any) => { setExamDuration(value) }} style={{ width: 100 }} />
                        <span style={{ marginLeft: 4 }}>分钟
                        </span>
                        <span style={{ marginLeft: 20, color: "#999" }}>
                            {` 时长不能超过1440分钟（24小时）`}</span>
                    </Form.Item>

                    <Form.Item label="开始时长" name="size" required>
                        <GraphicsEditor
               
                            isIntro={true}
                            detail={{
                                content: ''
                            }}
                            onChange={(val:any) => {  }}
                        />
                    </Form.Item>
                </Form>
            </div>

        </div>
        {
            showModal && <SelectPaperModal onSelect={(info: any) => {
                console.log(info, 'jkhjkhjk')
                setPaperInfo(info)
            }} paperInfo={paperInfo} close={() => { setShowModal(false) }}></SelectPaperModal>
        }

    </div>
}


export default withRouter(AddExam);