/*
 * @Author: wufan
 * @Date: 2020-11-30 10:47:38
 * @LastEditors: Please set LastEditors
 * @LastEditTime: 2021-08-11 20:31:26
 * @Description: 学员管理页面
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import _ from "underscore";
import {Tabs,Input,Tree,Button} from "antd";
import DepartMentTabCon from './components/DepartMentTabCon';
import "./NewUsersManagePage.less";

const { TabPane } = Tabs;


function UserManagePage() {
  const [currentTab, setCurrentTab] = useState("departMentTab");
  const [courseList,setCourseList] = useState([]);
  const [total, setTotal] = useState(0);
  const [query, setQuery] = useState({
    current: 0,
    size: 10,
  });
  
  return (
    <div className="page new-user-manage-page">
        <div className="content-header">学员管理</div>
        <div className="box">
          <div className="tab-box">
            <Tabs
              onChange={(key) => {
                setCurrentTab(key);
              }}
              activeKey={currentTab}
            >
              <TabPane key="departMentTab" tab="部门"></TabPane>
              <TabPane key="postGrouptab" tab="岗位组"></TabPane>
              <TabPane key="customGroupTab" tab="自定义分组"></TabPane>
            </Tabs>
          </div>
          <div className="box-body tab-con">
            <DepartMentTabCon currentTab={currentTab}/>
          </div>
        </div>
    </div>
  );
}

export default withRouter(UserManagePage);
