/*
 * @Author: 吴文洁
 * @Date: 2020-07-15 17:29:12
 * @Last Modified by: chenshu
 * @Last Modified time: 2021-03-29 16:19:49
 * @Description: 新建/编辑直播课-基本信息
 */

import React from 'react'
import { Input, Button, message, Cascader } from 'antd'
import { CourseCatalogSelect } from '@/modules/common'
import StoreService from '@/domains/store-domain/storeService'
import SelectPrepareFileModal from '@/modules/prepare-lesson/modal/SelectPrepareFileModal'
import Upload from '@/core/upload'
import ImgClipModal from '@/components/ImgClipModal'
import 'cropperjs/dist/cropper.css'
import './AddLiveBasic.less'

const defaultCover = 'https://image.xiaomaiketang.com/xm/Yip2YtFDwH.png'
const fieldNames = { label: 'categoryName', value: 'id', children: 'sonCategoryList' }
class AddLiveBasic extends React.Component {
  constructor(props) {
    super(props)
    this.state = {
      imageFile: null,
      showCutModal: false,
      courseCatalogList: [],
      showSelectFileModal: false,
      cutImageBlob: null,
      hasImgReady: false, // 图片是否上传成功
      cropperInstace:null,
      courseNameLimit: props.courseNameLimit?props.courseNameLimit:40
    }
  }
  componentWillUnmount() {}

  componentDidMount() {
    this.getCourseCatalogList()
  }
  getCourseCatalogList = () => {
    StoreService.getCourseCatalogList({ current: 1, size: 1000 }).then((res) => {
      this.setState({
        courseCatalogList: res.result.records,
      })
    })
  }

  // 使用默认封面图
  handleResetCoverUrl = () => {
    const {
      data: { coverUrl },
    } = this.props
    const isDefaultCover = coverUrl === defaultCover
    // 如果已经是默认图的话，不做任何任何处理
    if (isDefaultCover) return
    message.success('已替换为默认图')
    this.props.onChange('coverUrl', defaultCover)
    setTimeout(() => {
      this.props.onChange('coverId', null)
    }, 1000)
  }

  handleChangeCatalogList = (value) => {
    this.props.onChange('categoryId', value)
  }

  handleSelectCover = (file) => {
    this.setState({
      visible: true,
      imageFile: file,
    })
  }

  //获取resourceId
  getSignature = (blob) => {
    Upload.uploadBlobToOSS(blob, 'cover' + new Date().valueOf(), null, 'signInfo').then((signInfo) => {
      this.setState(
        {
          coverClicpPath: signInfo.fileUrl,
          coverId: signInfo.resourceId,
          visible: false,
        },
        () => this.updateCover()
      )
    })
  }
  updateCover = () => {
    const { coverClicpPath, coverId } = this.state
    this.setState({
      showSelectFileModal: false,
    })
    this.props.onChange('coverUrl', coverClicpPath)
    setTimeout(() => {
      this.props.onChange('coverId', coverId)
    }, 1000)
  }
  render() {
    const { imageFile, showSelectFileModal, visible } = this.state
    const { data } = this.props
    const { courseName, coverUrl, categoryId } = data
    // 当前是否使用的是默认图片
    const isDefaultCover = coverUrl === defaultCover
    return (
      <div className='add-live__basic-info'>
        <div className='course-name'>
          <span className='label'>
            <span className='require'>*</span>课程名称：
          </span>
          <div id="courseName" style={{display:"inline-block"}}>
          <Input
          className={_.find(this.props.exItems,(item)=>{return item === "courseName"})?"err":""}
            value={courseName}
            placeholder={`请输入直播名称(${this.state.courseNameLimit}字以内)`}
            maxLength={this.state.courseNameLimit}
            style={{ width: 240 }}
            onChange={(e) => {
              this.props.onChange('courseName', e.target.value)
            }}
          />
          </div>
        </div>
        <div className='course-cover'>
          <span className='label'>封面图：</span>

          <div className='course-cover__wrap'>
            
            <div className='img-content'>
              {isDefaultCover && <span className='tag'>默认图</span>}
              <img src={coverUrl} />
            </div>
          </div>
          <div className='opt-btns'>
              <Button
                onClick={() => {
                  this.setState({
                    showSelectFileModal: true,
                  })
                }}>
                上传图片
              </Button>
              <span className={`default-btn ${isDefaultCover ? 'disabled' : ''}`} onClick={this.handleResetCoverUrl}>
                使用默认图
              </span>
              <div className='tips'>建议尺寸1280*720px或16:9。封面图最大5M，支持jpg、jpeg和png。</div>
            </div>
        </div>
        <div className='course-catalog'>
          <span className='label'>
            <span className='require'>*</span>课程分类：
          </span>
          <div id="categoryId" style={{display:"inline-block"}}>
          <CourseCatalogSelect
            className={_.find(this.props.exItems,(item)=>{return item === "categoryId"})?"err":""}
            value={categoryId}
            onChange={(value, label) => {
              this.handleChangeCatalogList(value, label)
            }}
          />
          </div>
        </div>
        {showSelectFileModal && (
          <SelectPrepareFileModal
            key='basic'
            operateType='select'
            multiple={false}
            accept='image/jpeg,image/png,image/jpg'
            selectTypeList={['JPG', 'JPEG', 'PNG']}
            tooltip='支持文件类型：jpg、jpeg、png'
            isOpen={showSelectFileModal}
            onClose={() => {
              this.setState({ showSelectFileModal: false })
            }}
            onSelect={this.handleSelectCover}
          />
        )}
        {visible && (
          <ImgClipModal
            visible={visible}
            imgUrl={imageFile.ossUrl}
            onConfirm={this.getSignature}
            onClose={() => {
              this.setState({ visible: false })
            }}
          />
        )}
      </div>
    )
  }
}

export default AddLiveBasic
