/*
 * @Author: 吴文洁
 * @Date: 2020-07-16 11:05:17
 * @Last Modified by: chenshu
 * @Last Modified time: 2021-04-06 16:40:24
 * @Description: 添加直播-简介
 */

import React from 'react';
import { Input, message, Upload, Radio, Row, Col, Button, Popover, Switch } from 'antd';
import Service from '@/common/js/service';
import GraphicsEditor from './GraphicsEditor';
import User from '@/common/js/user';
import UploadOss from '@/core/upload';
import './AddLiveIntro.less';
import SelectPrepareFileModal from '@/modules/prepare-lesson/modal/SelectPrepareFileModal';
import { DISK_MAP } from '@/common/constants/academic/lessonEnum';
import { ImgCutModalNew } from '@/components';

const { TextArea } = Input;
const defaultCover = 'https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1599635741526.png';
class AddLiveIntro extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      warmUrl: defaultCover,
      showSelectFileModal: false,
      diskList: [],
      selectType: null,
    };
  }

  // 上传封面图
  handleShowImgCutModal = (event) => {
    const imageFile = event.target.files[0];
    if (!imageFile) return;
    this.setState({
      imageFile,
      showCutModal: true,
    });
  };

  // 选择暖场资源
  handleSelectVideo = (file) => {
    const { selectType } = this.state;
    this.setState({
      showSelectFileModal: false,
    });
    const { ossUrl, resourceId, folderName, folderFormat, folderSize } = file;
    if (selectType === 'WARMUP') {
      const liveCourseWarmMedia = {
        contentType: 'WARMUP',
        mediaType: folderFormat === 'MP4' || folderFormat === 'video/mp4' ? 'VIDEO' : 'PICTURE',
        mediaContent: resourceId,
        mediaUrl: ossUrl,
        mediaName: folderName,
        size: folderSize,
      };
      this.props.onChange('liveCourseWarmMedia', liveCourseWarmMedia);
    } else {
      // 最多添加九图片
      const { liveCourseMediaRequests } = this.props.data;

      const list = _.filter(liveCourseMediaRequests, (item) => {
        return item.mediaType == 'PICTURE';
      });
      if (list.length > 8) {
        message.warning('最多添加9张图片');
        return;
      }
      liveCourseMediaRequests.push({
        contentType: 'INTRO',
        size: folderSize,
        mediaName: folderName,
        mediaContent: resourceId,
        mediaType: 'PICTURE',
        mediaUrl: ossUrl,
      });
      this.props.onChange('liveCourseMediaRequests', liveCourseMediaRequests);
    }
  };

  changeIntro = (value) => {
    this.props.onChange('introduce', value);
  };

  whetherVisitorsJoinChange = () => {
    if (this.props.data.whetherVisitorsJoin === 'NO') {
      this.props.onChange('whetherVisitorsJoin', 'YES');
    } else {
      this.props.onChange('whetherVisitorsJoin', 'NO');
    }
  };

  render() {
    const {
      liveType,
      isXiaomai,
      isEdit,
      data: { id, introduce, needRecord, whetherVisitorsJoin, loadintroduce, liveCourseWarmMedia = {} },
    } = this.props;
    const { showCutModal, warmUrl, showSelectFileModal, diskList, imageFile, selectType } = this.state;
    return (
      <div className='add-live__intro-info'>
        <div className='playback'>
          <span className='label'>
            <span className='require'>*</span>直播回放：
          </span>
          <div className='content'>
            <Radio.Group
              value={needRecord}
              onChange={(e) => {
                this.props.onChange('needRecord', e.target.value);
              }}
              disabled={!isEdit ? true : false}>
              <Row style={{ marginBottom: '5px' }}>
                <Col span={24}>
                  <Radio value='YES'>
                    自动录制
                    <span className='playback__text'>系统自助进行全程直播录制</span>
                  </Radio>
                </Col>
              </Row>
              <Row>
                <Col span={24}>
                  <Radio value='NO'>
                    手动录制
                    <span className='playback__text'>讲师手动选择何时开始录制</span>
                  </Radio>
                </Col>
              </Row>
            </Radio.Group>
          </div>
        </div>
        <div className='allow-tourist-join'>
          <span className='label'>观看设置：</span>
          <div className='content'>
            <Switch checked={whetherVisitorsJoin === 'NO' ? true : false} onChange={this.whetherVisitorsJoinChange} />
            <div className='instro-text'>{whetherVisitorsJoin === 'NO' ? '已开启，学员需绑定手机号才可观看' : '已关闭，学员无需绑定手机号即可观看'}</div>
          </div>
        </div>
        <div className='warmup'>
          <span className='label'>直播暖场图：</span>
          <div className='course-cover__wrap'>
            <div className='img-content' style={liveCourseWarmMedia.mediaUrl ? { background: '#000' } : {}}>
              <img
                src={
                  liveCourseWarmMedia.mediaType === 'VIDEO'
                    ? `${liveCourseWarmMedia.mediaUrl}?x-oss-process=video/snapshot,t_0,m_fast`
                    : liveCourseWarmMedia.mediaUrl
                    ? liveCourseWarmMedia.mediaUrl
                    : defaultCover
                }
              />
              {liveCourseWarmMedia.mediaUrl && (
                <div className='img-delete-wrap'>
                  <img
                    src='https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1600073872956.png'
                    onClick={() => {
                      this.props.onChange('liveCourseWarmMedia', {});
                    }}
                  />
                </div>
              )}
            </div>
            <div className='opt-btns'>
              <Button
                disabled={!isEdit}
                onClick={() => {
                  this.setState({
                    showSelectFileModal: true,
                    selectType: 'WARMUP',
                  });
                }}>
                上传图片/视频
              </Button>

              <div className='tips'>
                <div>建议尺寸1280*720px或16:9。图片最大5M，支持jpg、jpeg和png；视频最大2G，</div>
                <div>支持mp4。</div>
              </div>

              <Popover
                content={
                  <div className='example-wrap'>
                    <p className='title'>直播间暖场图示例</p>
                    <p className='text'>直播开始前，展示在直播间视频区域</p>
                    <img src='https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1599644482652.png'></img>
                  </div>
                }>
                <div className='checkExample'>查看示例</div>
              </Popover>
            </div>
          </div>
        </div>

        <div className='introduce'>
          <span className='label'>课程简介：</span>
          <div className='content'>
            <div className='intro-list'>
              <div className='intro-list__item introduce-editor'>
                {(!id || loadintroduce) && (
                  <GraphicsEditor
                    id='intro'
                    isIntro={true}
                    maxLimit={1000}
                    detail={{
                      content: introduce,
                    }}
                    onChange={(val) => {
                      this.changeIntro(val);
                    }}
                  />
                )}
              </div>
            </div>
          </div>
        </div>
        {/* 选择暖场图文件弹窗 */}
        {showSelectFileModal && (
          <SelectPrepareFileModal
            key='instro'
            operateType='select'
            accept={selectType === 'INTRO' ? 'image/jpeg,image/png,image/jpg' : 'video/mp4,image/jpeg,image/png,image/jpg'}
            selectTypeList={selectType === 'INTRO' ? ['JPG', 'JPEG', 'PNG'] : ['MP4', 'JPG', 'JPEG', 'PNG']}
            tooltip={selectType === 'INTRO' ? '支持文件类型：jpg、jpeg、png' : '支持文件类型：jpg、jpeg、png、mp4'}
            isOpen={showSelectFileModal}
            onClose={() => {
              this.setState({ showSelectFileModal: false });
            }}
            onSelect={this.handleSelectVideo}
          />
        )}
      </div>
    );
  }
}

export default AddLiveIntro;
