/*
 * @Author: zhangleyuan
 * @Date: 2021-02-20 16:13:39
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2021-02-28 19:05:50
 * @Description: 描述一下
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { useEffect, useState } from "react";
import { Button, message, Modal} from 'antd';
import ShowTips from "@/components/ShowTips";
import Breadcrumbs from "@/components/Breadcrumbs";
import BasicInfo from './components/BasicInfo';
import TrainingTask from './components/TrainingTask'
import PlanService from '@/domains/plan-domain/planService'
import User from '@/common/js/user';
import _ from "underscore";
import './AddPlan.less'
const DEFAULT_BASIC_DATA = {
    planName:"",
    enableState:"YES",
    selectOperatorList:[],
    instro:'',
    operateType:'All_Operate',
    percentCompleteLive:80,
    percentCompleteVideo:80
}
function AddPlan() {
    const [basicData,setBasicData] = useState(DEFAULT_BASIC_DATA);
    const [taskList,setTaskList] = useState([]);
    function handleChangeBasicInfo(field, value){
        setBasicData( {
            ...basicData,
            [field]: value,
        })
    }

    function handleChangeTaskInfo(value){
        setTaskList(value)
    }

    function submitInfo(){
        const {planName,enableState,selectOperatorList,instro,operateType,percentCompleteLive,percentCompleteVideo} = basicData;
        if(!planName){
            message.warning('请输入的培训计划名称');
           return;
        }
        if(taskList.length === 0){
            message.warning('请输入培训计划内容');
            return;
        }
        
        const params = {
            createId:User.getStoreUserId(),
            enableState,
            operateIds:_.pluck(selectOperatorList,'id'),
            operateType,
            percentCompleteLive,
            percentCompleteVideo,
            planName,
            scheduleMediaRequests:[],
            storeId:User.getStoreId(),
            trainingTaskList:taskList

        } 
        PlanService.createTrainingPlan(params).then((res) => {
       
        });
    }
 
  return (
    <div className="page add-plan-page">   
        <Breadcrumbs
            navList={type == "add" ? "新建培训计划" : "编辑培训计划"}
        />
        <div className="box">
            <div className="show-tips">
                <ShowTips message="请遵守国家相关规定，切勿上传低俗色情、暴力恐怖、谣言诈骗、侵权盗版等相关内容，小麦企培保有依据国家规定及平台规则进行处理的权利" />
            </div>
            <div className="add-plan-page__form">
                <div className="basic-info__wrap">
                    <div className="title">基本信息</div>
                    <BasicInfo 
                      data={basicData}
                      onChange={handleChangeBasicInfo}
                    />
                </div>
                <div className="basic-info__wrap">
                    <div className="title">培训任务</div>
                    <TrainingTask onChange={handleChangeTaskInfo}/>
                </div>
            </div> 
        </div>
        <div className="footer">
            <Button>取消</Button>
            <Button type="primary" onClick={submitInfo}>保存</Button>
        </div>
    </div>    
  )

}
export default AddPlan;