/*
 * @Author: 吴文洁 
 * @Date: 2020-07-16 11:05:17 
 * @Last Modified by: chenshu
 * @Last Modified time: 2021-04-06 16:44:09
 * @Description: 添加直播-简介
 */

import React from 'react';
import { Input, message, Upload, Radio, Row, Col, Button, Popover, Switch } from 'antd';
import Service from '@/common/js/service';
import GraphicsEditor from '../../components/GraphicsEditor';
import User from '@/common/js/user';
import UploadOss from '@/core/upload';
import './AddVideoIntro.less';
import SelectPrepareFileModal from '@/modules/prepare-lesson/modal/SelectPrepareFileModal';
import { DISK_MAP } from '@/common/constants/academic/lessonEnum';
import { ImgCutModalNew } from '@/components';


const { TextArea } = Input;
const defaultCover = 'https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1599635741526.png';
class AddVideoIntro extends React.Component {

  constructor(props) {
    super(props);
    this.state = {
      warmUrl: defaultCover,
      showSelectFileModal: false,
      diskList: [],
      selectType:null
    }
  }

  // 上传封面图
  handleShowImgCutModal = (event) => {
    const imageFile = event.target.files[0];
    if (!imageFile) return;      
    this.setState({
      imageFile,
      showCutModal: true,
    });
  }

   // 选择暖场资源
   handleSelectVideo = (file) => {
    const { selectType } = this.state; 
    this.setState({
      showSelectFileModal: false
    })
    const { ossUrl, resourceId, folderName, folderFormat, folderSize } = file;
    if(selectType === 'WARMUP'){
      const liveCourseWarmMedia = {
        contentType: 'WARMUP',
        mediaType: folderFormat === 'MP4' ? 'VIDEO' : 'PICTURE',
        mediaContent: resourceId,
        mediaUrl: ossUrl,
        mediaName: folderName,
        size: folderSize
      }
      this.props.onChange('liveCourseWarmMedia', liveCourseWarmMedia);
    }else{
        // 最多添加九图片
        const { liveCourseMediaRequests } = this.props.data;

        const list = _.filter(liveCourseMediaRequests, (item) => {
          return item.mediaType == "PICTURE";
        });
        if (list.length > 8) {
          message.warning("最多添加9张图片");
          return;
        }
        liveCourseMediaRequests.push({
          contentType: 'INTRO',
          size: folderSize,
          mediaName: folderName,
          mediaContent: resourceId,
          mediaType: 'PICTURE',
          mediaUrl: ossUrl,
        });
        this.props.onChange('liveCourseMediaRequests', liveCourseMediaRequests);
    }
   
  }

  changeIntro = (value) => {
    this.props.onChange('introduce', value);
  }

  handleUpload = (Blob) => {
    this.setState({
      showSelectFileModal: true,
      selectType:'INTRO'
    })
  }
  whetherVisitorsJoinChange = ()=>{
    if(this.props.data.whetherVisitorsJoin==="NO"){
      this.props.onChange('whetherVisitorsJoin','YES')
    }else{
      this.props.onChange('whetherVisitorsJoin','NO')
    }
  }
  shelfStateChange = ()=>{
    if(this.props.data.shelfState==="NO"){
      this.props.onChange('shelfState','YES')
    }else{
      this.props.onChange('shelfState','NO')
    }
  }
  
  render() {
    const {data: { whetherVisitorsJoin,liveCourseMediaRequests = [], shelfState, id, introduce, loadintroduce } } = this.props;
    const {showSelectFileModal,selectType} = this.state
    return (
      <div className="add-video__intro-info">
        <div className="allow-tourist-join">
          <span className="label">观看设置：</span>
          <div className="content">
            <div>
                <Switch checked={whetherVisitorsJoin==="NO"? true:false} onChange={this.whetherVisitorsJoinChange}/>
            </div>  
            <div>
              <div className="desc">
              <Choose>
                <When condition={whetherVisitorsJoin==="NO"}>
                <div>已开启，学员需绑定手机号才可观看</div>
                </When>
                <Otherwise>
                <div>已关闭，学员无需绑定手机号即可观看</div>
                </Otherwise>
              </Choose>                
              </div>
            </div> 
          </div>
        </div>
        <div className="store-show">
          <span className="label">学院展示：</span>
          <div className="content">
              <Row>
                <Col span={3}>
                    <Switch checked={shelfState==="YES"? true:false} onChange={this.shelfStateChange}/>
                </Col>  
                <Col span={21}>
                  <div className="desc">
                    <Choose>
                      <When condition={shelfState==="YES"}>
                      <div>已开启，课程将在该学院的学员课程列表中显示</div>
                      </When>
                      <Otherwise>
                      <div>已关闭，课程将在该学院的学员课程列表中隐藏</div>
                  </Otherwise>
                </Choose>
                  </div>
                </Col> 
              </Row>
          </div>
        </div>
        <div className="introduce">
          <span className="label">线上课简介：</span>
          <div className="content">
            <div className="intro-list">
              <div className="intro-list__item introduce-editor">
                {(!id || loadintroduce) &&
                  <GraphicsEditor
                    maxLimit={1000}
                    id="intro"
                    isIntro={true}
                    detail={{
                      content: introduce
                    }}
                    onChange={(val) => { this.changeIntro(val) }}
                  />
                }
              </div>
            </div>
          </div>
        </div>
        {/* 选择暖场图文件弹窗 */}
        { showSelectFileModal &&
          <SelectPrepareFileModal
            operateType="select"
            accept={selectType==="INTRO"?"image/jpeg,image/png,image/jpg":"video/mp4,image/jpeg,image/png,image/jpg"}
            selectTypeList={ selectType==="INTRO" ? ['JPG', 'JPEG', 'PNG']: ['MP4', 'JPG', 'JPEG', 'PNG'] }
            tooltip={ selectType==="INTRO"?'支持文件类型：jpg、jpeg、png':'支持文件类型：jpg、jpeg、png、mp4'}
            isOpen={showSelectFileModal}
            onClose={() => {
              this.setState({ showSelectFileModal: false })
            }}
            onSelect={this.handleSelectVideo}
          />
        }
      </div>
    )
  }
}

export default AddVideoIntro;
